/* PressMart theme activation*/
jQuery( function ( $ ) {
	"use strict";
	var pressmart_activation = pressmart_activation || {};
	pressmart_activation.init = function() {
		var self = this;
		pressmart_activation.$doc          	= $(document)
		pressmart_activation.$html    		= $('html'),
		pressmart_activation.$body 			= $(document.body),
		pressmart_activation.$window 		= $(window),
		pressmart_activation.$windowWidth 	= $(window).width(),
		pressmart_activation.$windowHeight 	= $(window).height();
		self.activate_theme();
		self.deactivate_theme();
	};
	
	pressmart_activation.activate_theme = function() {
		// Activate theme
		$('body').on('click', '.pressmart-activate-btn', function() {
			var purchase_code = $(".purchase-code").val();
			var activate_btn = $(this);
			activate_btn.addClass('loading');
			if( $.trim(purchase_code) != ''){
				$(this).attr('disabled', 'true');
				var data = {
					action      	: 'activate_theme',
					purchase_code   : purchase_code,
					nonce   		: pressmart_admin_params.nonce,
				};
				$.post(ajaxurl,data,function(response) {
					
					var data = $.parseJSON(response);
					
					if(data.success == '1'){
						alert(data.message);
						setTimeout(function(){location.reload();}, 5000);
					}else{
						alert(data.message);
						activate_btn.removeClass('loading');
						activate_btn.removeAttr('disabled');
					}			
				});
			} else {
				alert('Please Enter Purchase Code');
			}
			
			return false;
		});
	};
	
	
	pressmart_activation.deactivate_theme = function() {
		// deactivate theme
		$('body').on('click', '.pressmart-deactivate-btn', function() {
			var purchase_code = $(".purchase-code").val();
			var activate_btn = $(this);
			activate_btn.addClass('loading');
			if( $.trim(purchase_code) != ''){
				$(this).attr('disabled', 'true');
				var data = {
					action      	: 'deactivate_theme',
					purchase_code   : purchase_code,
					nonce   		: pressmart_admin_params.nonce,
				};
				$.post(ajaxurl,data,function(response) {
					
					var data = $.parseJSON(response);
					
					if(data.success == '1'){
						alert(data.message);
						
						setTimeout(function(){location.reload();}, 5000);
					}else{
						alert(data.message);
						activate_btn.removeClass('loading');
						activate_btn.removeAttr('disabled');
					}
				});
			} else {
				alert('Purchase code is empty.');
			}
			//$(this).attr('disabled', 'true');
			return false;
		});
	};
	
	/**
	 * Document ready
	 */ 
	$(document).ready(function(){ 
		pressmart_activation.init();
    });
	
});
