<?php
 /**
 * PressMart Include Admin Customizer Function
 *
 * @package WordPress
 * @subpackage PressMart
 * @since PressMart 1.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class PressMart_Admin {
	public $prefix, $current_version, $api_url, $api_key;
	
	function __construct() {
		$this->prefix 			= PRESSMART_PREFIX;
		$theme_data 			= wp_get_theme();
        $this->current_version 	= $theme_data->get('Version');
        $this->api_url 			= 'https://www.presslayouts.com/api/envato';
        $this->api_key 			= 'token';		
		
		/*Admin menu*/
		add_action( 'admin_menu', array( $this, 'theme_page_menu' ) );		
		
		// Register walker replacement
		add_action('wp_update_nav_menu_item', array( $this, 'save_custom_fields' ), 10, 3 );		
		add_action( 'wp_nav_menu_item_custom_fields',   array( $this, 'custom_menu_field'), 10 , 4 );
	}
	
	public function theme_page_menu() {
		$menu_title = apply_filters( 'pressmart_menu_title', 'PressMart' );
		$menu_icon = apply_filters( 'pressmart_menu_icon', PRESSMART_URI.'/inc/admin/assets/images/menu-icon.png' );
		
        add_menu_page( $menu_title,
			$menu_title,
            'manage_options',
            'pressmart-theme',
            array( $this, 'pressmart_dashboard_page' ),$menu_icon,
			25
        );
		add_submenu_page( 'pressmart-theme',
            esc_html__( 'Welcome', 'pressmart' ),
            esc_html__( 'Welcome', 'pressmart' ),
            'manage_options',
            'pressmart-theme',
            array( $this, 'pressmart_dashboard_page' )
        );
		add_submenu_page( 'pressmart-theme',
            esc_html__( 'System Status', 'pressmart' ),
            esc_html__( 'System Status', 'pressmart' ),
            'manage_options',
            'pressmart-system-status',
            array( $this, 'pressmart_system_status' )
        );		
    }
	
	public function pressmart_dashboard_page() {
		require( PRESSMART_FRAMEWORK. '/admin/dashboard/welcome.php' );
	}
	
	public function pressmart_system_status() {		 
		require(PRESSMART_FRAMEWORK. '/admin/dashboard/system_status.php' );
	}
	
	public function save_custom_fields($menu_id, $menu_item_db_id, $args){
		
		$custom_fields = array('enable','design','width','height','custom_block','label_text','label_color','icon','thumbnail_url','attachment_id');

		foreach ( $custom_fields as $key ) {
			$value = isset($_REQUEST['menu-item-'.$key][$menu_item_db_id]) ? $_REQUEST['menu-item-'.$key][$menu_item_db_id] : '';
			update_post_meta( $menu_item_db_id, '_menu_item_pressmart_'.$key, $value );
		}
	}
		
	public function custom_menu_field($item_id, $item, $depth, $args ){
		
		$enable  		= get_post_meta( $item_id, '_menu_item_pressmart_enable',  true );
		$design  		= get_post_meta( $item_id, '_menu_item_pressmart_design',  true );
		$custom_block  	= get_post_meta( $item_id, '_menu_item_pressmart_custom_block',  true );
		$height  		= get_post_meta( $item_id, '_menu_item_pressmart_height',  true );
		$width   		= get_post_meta( $item_id, '_menu_item_pressmart_width',   true );
		$label_text   	= get_post_meta( $item_id, '_menu_item_pressmart_label_text',  true );
		$label_color   	= get_post_meta( $item_id, '_menu_item_pressmart_label_color',  true );
		$icon    		= get_post_meta( $item_id, '_menu_item_pressmart_icon',    true );		
		$attachment_id  = get_post_meta( $item_id, '_menu_item_pressmart_attachment_id',  true );
		$thumbnail_url  = get_post_meta( $item_id, '_menu_item_pressmart_thumbnail_url',  true );
		$icon_btn_text = (!empty($thumbnail_url)) ? esc_html__('Change Custom Icon','pressmart') : esc_html__('Upload Custom Icon','pressmart');
		$megamenu_class = ($enable != 'enabled') ? 'hidden-field' : '';
		$img_remove_cls = (empty($thumbnail_url)) ? 'hidden-field' : '';
		$custom_size_class = (($design == 'custom-size') && ($enable == 'enabled')) ? '' : 'hidden-field';
		$custom_blocks = pressmart_get_posts_by_post_type('block');
		$custom_block_edit_link = !empty($custom_block) ? admin_url( 'post.php?post='.$custom_block.'&action=edit' ) : 'javascript:void();'; ?>
		
		<!--  PressMart custom fields-->
		<div id="pressmart-custom-fields" class="pressmart-custom-fields">
			<p class="description description-wide pressmart-megamenu-enable">
				<label for="edit-menu-item-megamenu-enable-<?php echo esc_attr( $item_id ); ?>">
					<input type="checkbox" id="edit-menu-item-megamenu-enable-<?php echo esc_attr( $item_id ); ?>" data-itemid=<?php echo esc_attr( $item_id ); ?> class="widefat code edit-menu-item-megamenu-enable" name="menu-item-enable[<?php echo esc_attr( $item_id ); ?>]" value="enabled" <?php checked($enable,'enabled')?> />
					<strong><?php esc_html_e( 'Enable Mega Menu (only for main menu)', 'pressmart' ); ?></strong>
				</label>
			</p>
			<p class="description description-wide pressmart-menu-design megamenu-field <?php echo esc_attr($megamenu_class);?>">
				<label for="edit-menu-item-design-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e('Design', 'pressmart'); ?><br>
					<select id="edit-menu-item-design-<?php echo esc_attr( $item_id ); ?>" data-field="pressmart-menu-design" data-itemid="<?php echo esc_attr( $item_id ); ?>" class="widefat pressmart-menu-design" name="menu-item-design[<?php echo esc_attr( $item_id ); ?>]">
						<option value="full-width" <?php selected( esc_attr( $design ), 'full-width', true); ?>><?php esc_html_e('Full width', 'pressmart'); ?></option>
						<option value="custom-size" <?php selected( esc_attr( $design ), 'custom-size', true); ?>><?php esc_html_e('Custom sizes', 'pressmart'); ?></option>
					</select>
				</label>
			</p>
			<div id="pressmart-custom-design-block-<?php echo esc_attr( $item_id ); ?>" class="pressmart-custom-design-block <?php echo esc_attr($custom_size_class);?>">
			<p class="description description-thin pressmart-menu-width">
				<label for="edit-menu-item-width-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e('Width', 'pressmart'); ?><br>
					<input type="number" id="edit-menu-item-width-<?php echo esc_attr( $item_id ); ?>" class="widefat" name="menu-item-width[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($width);?>">
				</label>
			</p>			
			<p class="description description-thin pressmart-menu-height ">
				<label for="edit-menu-item-height-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e('Height', 'pressmart'); ?><br>
					<input type="number" id="edit-menu-item-height-<?php echo esc_attr( $item_id ); ?>" class="widefat" name="menu-item-height[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($height);?>">
				</label>
			</p>
			</div>
			<p class="description description-wide pressmart-menu-custom-block megamenu-field <?php echo esc_attr($megamenu_class);?>">
				<label for="edit-menu-item-custom-block-<?php echo esc_attr( $item_id ); ?>">
					<?php esc_html_e('Select block', 'pressmart'); ?><br>
					<select id="edit-menu-item-custom-block-<?php echo esc_attr( $item_id ); ?>" data-field="pressmart-menu-custom-block" class="widefat pressmart-custom-block select" name="menu-item-custom_block[<?php echo esc_attr( $item_id ); ?>]">
						<option value=""><?php esc_html_e('Select block','pressmart');?></option>
						<?php
						if(!empty($custom_blocks)){
							foreach ($custom_blocks as $id => $title) {
							$edit_link = admin_url( 'post.php?post='.$id.'&action=edit' );
							?>
							<option value="<?php echo esc_attr($id);?>" <?php selected($custom_block,$id); ?> data-block-link="<?php echo esc_url($edit_link);?>"><?php echo esc_html($title);?></option>
							<?php
							}
						}
						?>
					</select>
					<?php if(!empty( $custom_block ) ){?>
					<a href="<?php echo esc_url($custom_block_edit_link);?>" class="edit-block-link" target="_blank"><?php esc_html_e( 'Edit megamenu block', 'pressmart' ); ?></a> | 
					<?php } ?>
					<a href="<?php echo esc_url( admin_url( 'post-new.php?post_type=block' ) ); ?>" class="add-block-link" target="_blank"><?php esc_html_e( 'Add megamenu block', 'pressmart' ); ?></a>
				</label>
			</p>
			
			<p class="description description-thin pressmart-label-text">
				<label for="edit-menu-item-label-text-<?php echo esc_attr( $item_id ); ?>">					
					<?php esc_html_e('Label text','pressmart');?><br>
					<input id="edit-menu-item-label-text-<?php echo esc_attr( $item_id ); ?>" class="widefat" name="menu-item-label_text[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($label_text);?>" type="text">
				
			</p>
			<p class="description description-thin pressmart-label-color">
				<label for="edit-menu-item-label-color-<?php echo esc_attr( $item_id ); ?>">					
					<?php esc_html_e('Label color','pressmart');?></label><br>
					<input id="edit-menu-item-label-color-<?php echo esc_attr( $item_id ); ?>" class="widefat pressmart-color-box" name="menu-item-label_color[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($label_color);?>" type="text">
				
			</p>
			<p class="description description-thin pressmart-menu-icon">
				<label for="edit-menu-item-icon-<?php echo esc_attr( $item_id ); ?>">
					<a href="#" class="button-secondary pick-icon"><i class=" fa <?php echo esc_attr($icon);?>"></i> <?php esc_html_e( 'Menu Icon', 'pressmart' ) ?></a>
					<span class="icons-block">
						<input type="text" class="search-icon" placeholder="<?php esc_attr_e( 'Quick search', 'pressmart' ) ?>">
						<span class="pressmart-icon-close"> X </span>
						<span class="icon-selector">
							<i data-icon="">&nbsp;</i>
							<?php echo implode( "\n", pressmart_get_pls_icons($icon) ); ?>
						</span>
					</span>
					<input type="hidden" name="menu-item-icon[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($icon);?>">
				</label>
			</p>			
			<p class="description description-thin pressmart-menu-icon-img">				
				<label for="edit-menu-item-megamenu-thumbnail-<?php echo esc_attr( $item_id ); ?>">
					<span class="img-wrp">
						<?php if(!empty($thumbnail_url)){?>
						<img src="<?php echo esc_url($thumbnail_url);?>" id="pressmart-media-img-<?php echo esc_attr( $item_id ); ?>" data-itemid = "<?php echo esc_attr( $item_id ); ?>" class="pressmart-megamenu-thumbnail-image pressmart-attr-img" height="32" width="32" align="left" alt="<?php echo esc_attr__('Menu icon','pressmart');?>"/>
						<span data-itemid = "<?php echo esc_attr( $item_id ); ?>" class="pressmart-menu-image-clear"></span>
						<?php }?>
					</span>					
					<a href="#" id="pressmart-media-upload-<?php echo esc_attr( $item_id ); ?>" data-itemid = "<?php echo esc_attr( $item_id ); ?>" class="pressmart-menu-image-upload button button-primary"><?php echo esc_html($icon_btn_text ); ?></a>
				</label>
				<input type="hidden" id="edit-menu-item-thumbnail-url-<?php echo esc_attr( $item_id ); ?>" data-itemid = "<?php echo esc_attr( $item_id ); ?>" name="menu-item-thumbnail_url[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($thumbnail_url);?>" />
				<input type="hidden" id="pressmart-attachment-<?php echo esc_attr( $item_id ); ?>" data-itemid = "<?php echo esc_attr( $item_id ); ?>" name="menu-item-attachment_id[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr($attachment_id);?>" />
			</p>
			
		</div><!-- End #pressmart-custom-fields. -->
		
	<?php
	}
}
$obj_pressmart_admin = new PressMart_Admin();