<?php
/**
 * PressMart Theme Options
 */

if ( ! class_exists( 'Redux' ) ) {
	return;
}

    $opt_name = 'pressmart_options';
    $theme = wp_get_theme( 'PressMart' );
	
    $args = array(
        'opt_name'             => $opt_name,
        'display_name'         => apply_filters( 'pressmart_theme_name',$theme->get( 'Name' ) ),
        'display_version'      => $theme->get( 'Version' ),
        'menu_type'            => 'submenu',
        'allow_sub_menu'       => true,
        'menu_title'           => esc_html__( 'Theme Options', 'pressmart' ),
        'page_title'           => esc_html__( 'Theme Options', 'pressmart' ),
		'google_api_key'       		=> '',
        'google_update_weekly' 		=> false,
        'async_typography'     		=> false,
        'global_variable'      		=> '',
        'dev_mode'             		=> false,
        'customizer'          		=> true,
        'page_priority'       		=> null,
        'page_parent'          		=> 'pressmart-theme',
        'page_permissions'     		=> 'manage_options',
        'menu_icon'            		=> '',
        'page_icon'            		=> 'icon-themes',
        'page_slug'            		=> 'pressmart-theme-option',
        'save_defaults'        		=> true,
        'default_show'         		=> false,
        'default_mark'         		=> '',
        'show_import_export'   		=> true,
        'transient_time'       		=> 60 * MINUTE_IN_SECONDS,
        'output'               		=> true,
        'output_tag'           		=> true,
		'font_display'              => 'swap',
		'footer_credit'             => ' ',
    );

    Redux::setArgs( $opt_name, $args );

    /* END ARGUMENTS */

	
    /* START SECTIONS  */

    // -> START Basic Fields
	
	/*
	* General
	*/
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'General', 'pressmart' ),
        'id'               => 'general-options',
        'desc'             => '',
		'fields'           => array(
			array(
                'id'       			=> 'theme-layout',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Theme Layout', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Select layout of site.', 'pressmart' ),
                'options'  			=> array(
					'wide' => array(
                        'title' 	=> esc_html__( 'Wide', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Wide', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/wide.png',
                    ),  
					'full' => array(
                        'title' 	=> esc_html__( 'Full', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Full', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/full.png',
                    ),                   
                    'boxed' => array(
                        'title' 	=> esc_html__( 'Boxed', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Boxed', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/box.png',
                    ),
                ),
                'default'  		=> 'full',
            ),
			array(
                'id'            	=> 'theme-container-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Container Width (px)', 'pressmart' ),
				'subtitle'          => esc_html__( 'Theme container width in pixels', 'pressmart' ),
                'default'       	=> 1200,
                'min'           	=> 1025,
                'step'          	=> 1,
                'max'           	=> 1920,
				'required' 			=> array( 'theme-layout', '=', array( 'full', 'boxed' ) ),
            ),
			array(
                'id'            	=> 'theme-container-wide-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Container Width (px)', 'pressmart' ),
				'subtitle'          => esc_html__( 'Theme container wide layout width in pixels', 'pressmart' ),
                'default'       	=> 1820,
                'min'           	=> 1200,
                'step'          	=> 1,
                'max'           	=> 1920,
				'required' 			=> array( 'theme-layout', '=', array( 'wide' ) ),
            ),
			array(
                'id'            	=> 'theme-grid-gap',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Grid Gap', 'pressmart' ),
				'subtitle'          => esc_html__( 'Theme grid gapping/spacing between two columns. Like 5px, 10px, 15px, etc...', 'pressmart' ),
                'default'       	=> 10,
                'min'           	=> 5,
                'step'          	=> 5,
                'max'           	=> 20,
            ),
			array(
                'id'       			=> 'header-logo',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Logo', 'pressmart' ),
                'compiler' 			=> 'true',
                'subtitle' 			=> esc_html__( 'Upload header logo.', 'pressmart' ),
                'default'  			=> array(),
            ),
			array(
                'id'       			=> 'header-logo-light',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Logo Light Version', 'pressmart' ),
				'subtitle'          => esc_html__( 'Upload an alternative light logo that will be used on dark and transparent header.', 'pressmart' ),
                'compiler' 			=> 'true',
               'default'  			=> array(),
			),
			array(
                'id'            	=> 'header-logo-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Logo Width', 'pressmart' ),
				'subtitle'          => esc_html__( 'Logo width in pixels', 'pressmart' ),
                'default'       	=> 170,
                'min'           	=> 50,
                'step'          	=> 1,
                'max'           	=> 500,
                'display_value' 	=> 'text',
            ),
			array(
                'id'      			=> 'mobile-header-logo',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Mobile Header Logo', 'pressmart' ),
				'subtitle'          => esc_html__( 'Upload mobile header logo', 'pressmart' ),
                'compiler' 			=> 'true',
				'default'  			=> array(),
			),
			array(
                'id'            	=> 'mobile-header-logo-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Mobile Header Logo Width', 'pressmart' ),				
				'subtitle'          => esc_html__( 'Logo max width in pixels', 'pressmart' ),
                'default'       	=> 120,
                'min'           	=> 50,
                'step'          	=> 1,
                'max'           	=> 500,
                'display_value' 	=> 'text',
            ),
		)
    ) );
	
	/**
	* Site Preloader
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Site Preloader', 'pressmart' ),
        'id'         		=> 'section-site-preloader',
		'subsection'		=> true,
        'fields'     => array(
			array(
                'id'       			=> 'site-preloader',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Site Preloader', 'pressmart' ),
                'subtitle'    		=> esc_html__( 'Enable/disable preloader on your website', 'pressmart' ),
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
                'off'      			=> esc_html__( 'Disable', 'pressmart' ),
                'default'  			=> 0,
            ),
			array(
                'id'       			=> 'preloader-background',
                'type'    			=> 'color',
				'title'   			=> esc_html__( 'Preloader Background', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Set preloader background color.', 'pressmart' ),				
				'transparent'		=> false,
				'default'    		=> '#059473',
				'required' 			=> array( 'site-preloader', '=', 1 ),
            ),
			array(
				'id'      			=> 'preloader-image',
				'type'    			=> 'button_set',
				'title'   			=> esc_html__( 'Preloader Image', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Set preloader type as per your need.', 'pressmart' ),
				'options' 			=> array(
					'predefine-loader'	=> esc_html__( 'Predefined Loader', 'pressmart' ),
					'custom'         	=> esc_html__( 'Custom', 'pressmart' ),
				),
				'default' 			=> 'predefine-loader',
				'required' 			=> array( 'site-preloader', '=', 1 ),
			),
			array(
                'id'       			=> 'predefine-loader-style',
                'type'     			=> 'select',
				'title'   			=> esc_html__( 'Choose Preloader Style', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Set preloader type as per your need.', 'pressmart' ),
                'options'  			=> array(
                    '1' => 'Style 1',
                    '2' => 'Style 2',
                    '3' => 'Style 3',
                    '4' => 'Style 4',
                    '5' => 'Style 5',
                ),
                'default'  			=> '1',
				'required' 			=> array( 'site-preloader', '=', 1 ),
            ),
			array(
				'id'      			=> 'preloader-custom-image',
				'type'    			=> 'media',
				'url'     			=> false,
				'title'   			=> esc_html__( 'Upload Preloader Image', 'pressmart' ),   
				'subtitle'			=> esc_html__( 'Upload preloader image.', 'pressmart' ),
				'library_filter'	=> array( 'gif', 'jpg', 'jpeg', 'png' ),
				'required'      	=> array( 'preloader-image', '=', 'custom' ),
			),
		)
	) );
	
	/*
	* Back to top options
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Back To Top Button', 'pressmart' ),
        'id'         		=> 'section-back-to-top',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'back-to-top',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Button', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Enable/disable back to top button.', 'pressmart' ),
                'default'  			=> 1,
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
                'off'      			=> esc_html__( 'Disable', 'pressmart' ),
            ),
			array(
                'id'       			=> 'back-to-top-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Button In Mobile', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Enable/disable back to top button in mobile device.', 'pressmart' ),
                'default'  			=> 1,
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
                'off'      			=> esc_html__( 'Disable', 'pressmart' ),
            ),
		)
	) );
	
	/*
	* Promo Bar
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Promo Bar', 'pressmart' ),
        'id'         		=> 'section-promo-bar',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'promo-bar',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Promo Bar', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Enable/disable promo bar.', 'pressmart' ),
                'default'  			=> 0,
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
                'off'      			=> esc_html__( 'Disable', 'pressmart' ),
			),			
			array(
                'id'            	=> 'promo-bar-height',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Height', 'pressmart' ),
				'subtitle'          	=> esc_html__( 'Promo bar height in pixels.', 'pressmart' ),
                'default'       	=> 60,
                'min'           	=> 10,
                'step'          	=> 1,
                'max'           	=> 500,
                'display_value' 	=> 'text',
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-position',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Position', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Select location for promo bar.', 'pressmart' ),
                'options'  			=> array(
                    'top' 		=> esc_html__( 'Top', 'pressmart' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'pressmart' ),
                ),
                'default'  			=> 'top',
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-position-type',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Position Type', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Select position type for promo bar.', 'pressmart' ),
                'options'  			=> array(
                    'absolute' 	=> esc_html__( 'Absolute', 'pressmart' ),
                    'fixed' 	=> esc_html__( 'Fixed', 'pressmart' ),
                ),
                'default'  			=> 'absolute',
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-message-text',
                'type'     			=> 'editor',
                'title'    			=> esc_html__( 'Message', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter promo message.', 'pressmart' ),
				'default'  			=> esc_html__( 'SUMMER SALE, Get 40% Off for all products.', 'pressmart' ),
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       			=> 'promo-bar-link-btn',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Button', 'pressmart' ),
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
				'off'      			=> esc_html__( 'Disable', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enable link button in promo bar.', 'pressmart' ),
				'default'  			=> 1,
				'required' 			=> array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       => 'promo-bar-link-btn-text',
                'type'     => 'text',
                'title'    =>  esc_html__( 'Button Text', 'pressmart' ),
                'subtitle' => esc_html__( 'The text of the more info button.', 'pressmart' ),
				'default'  => esc_html__( 'Click Here', 'pressmart' ),
				'required' => array( 'promo-bar-link-btn', '=', 1 ),
            ),
			array(
                'id'       => 'promo-bar-link-btn-url',
                'type'     => 'text',
                'title'    => esc_html__( 'Enter Url', 'pressmart' ),
                'subtitle' => esc_html__( 'The text of the more info button.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'promo-bar-link-btn', '=', 1 ),
            ),
			array(
                'id'       => 'promo-bar-link-open-new-tab',
                'type'     => 'switch',
                'title'    => esc_html__( 'Open link in New Tab', 'pressmart' ),
                'subtitle' => esc_html__( 'Select the link target for more info page.', 'pressmart' ),
				'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
                'default'  => 1,
				'required' => array( 'promo-bar-link-btn', '=', 1 ),
            ),
			array(
                'id'       => 'promo-bar-close-btn',
                'type'     => 'switch',
                'title'    => esc_html__( 'Close Button', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Enable close button.', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'promo-bar', '=', 1 ),
            ),
			array(
                'id'       => 'promo-bar-dismiss',
                'type'     => 'switch',
                'title'    => esc_html__( 'Promo Bar Dismissing', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Enable/Disable promo bar dismissing on button close.', 'pressmart' ),
				'default'  => 0,
				'required' => array( 'promo-bar-close-btn', '=', 1 ),
            ),
			array(
                'id'    => 'promo-notice1',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Promo Bar Colors', 'pressmart' ),
            ),
			array (
				'id'       		=> 'promo-bar-background',
				'type'     		=> 'background',
				'title'    		=> esc_html__( 'Background', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Promo bar background image or color', 'pressmart' ),
				'output' 		=> array( '.pressmart-promo-bar' ),
				'default'  		=> array(
					'background-color'	 	=> '#191919',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       		=> 'promo-button-text-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Text Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button text color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
			array(
                'id'       		=> 'promo-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Background Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button background color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#059473',
                    'hover'   	=> '#048567',
                )
            ),
			array(
				'id'          		=> 'promo-bar-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Promo Bar Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'These settings control the typography for promo bar.', 'pressmart' ),
				'output' 			=> array( '.promo-bar-msg, .promo-bar-close' ),
				'default'     		=> array(
					'color'       		=> '#ffffff', 
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> '',
					'font-size'   		=> '14px', 
					'letter-spacing'	=> '',
				),
			),
		)
	) );
	
	/*
	* Lazyload Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Lazy Load Images', 'pressmart' ),
        'id'         		=> 'section-lazy-load',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       		=> 'lazy-load',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Lazy Load Images', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Enables lazy load to reduce page requests.', 'pressmart' ),
                'on'       		=> esc_html__( 'Enable', 'pressmart' ),
                'off'      		=> esc_html__( 'Disable', 'pressmart' ),
                'default'  		=> 0,
            ),
		)
	) );
	
	/*
	* Google Map API
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'API Key', 'pressmart' ),
        'id'         		=> 'section-api-key',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'   				=> 'google-map-api',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Google Map API Key', 'pressmart' ),
				'subtitle'			=> wp_kses( 
					sprintf( 
						__( 'You should create an API for yourself and put code here. read below link to more info: <a href="%s" target="_blank">here</a>.', 'pressmart' ),
						esc_url('https://developers.google.com/maps/documentation/javascript/get-api-key')
					),
					array( 
						'a'	=> array( 
							'href' 		=> array(), 
							'target'	=> array() 
						) 
					) 
				),
				'default'  			=> '',
            ),
			array(
                'id'   				=> 'instagram-access-token',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Instagram Access Token', 'pressmart' ),
				'subtitle'			=> wp_kses( 
					sprintf( 
						__( 'You should create an API for yourself and put code here. read below link to more info: <a href="%s" target="_blank">here</a>.', 'pressmart' ),
						esc_url('https:/presslayouts.com/')
					),
					array( 
						'a'	=> array( 
							'href' 		=> array(), 
							'target'	=> array() 
						) 
					) 
				),
				'default'  			=> '',
            ),
		),
	) );
	
	/*
	* Mobile
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Mobile', 'pressmart' ),
        'id'         => 'section-mobile',
		'icon'		 => 'el el-iphone-home',
        'fields'     => array(
			array(
                'id'       			=> 'mobile-categories-menu',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Categories Menu', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show categories menu in mobile.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-menu-header-login-register',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Login/Register', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show login/register on mobile menu header.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'mobile-menu-social-profile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Social Profile', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show social profile in mobile menu.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'product-hover-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Product Hover', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'By default display product hover in mobile.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'mobile-product-hover-image',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Hover Image In Mobile', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show product hover image in mobile layout.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
		),
	) );
	
	/*
	* Mobile Navbar
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Footer Navbar', 'pressmart' ),
        'id'         		=> 'section-mobile-navbar',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       		=> 'mobile-bottom-navbar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Mobile Bottom Navbar', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show mobile bottom navbar in mobile device.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0
            ),
			array(
                'id'       		=> 'mobile-navbar-label',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Navbar Label', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show navbar label.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'mobile-navbar-color',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Navbar Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Select navbar color style.', 'pressmart' ),
                'options'  		=> array(
					'light'	=> esc_html__( 'Light', 'pressmart' ),
					'dark'	=> esc_html__( 'Dark', 'pressmart' ),
				),
				'default'  		=> 'light',
            ),
			array(
                'id'       		=> 'mobile-product-page-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Page Button', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Enable/Disable Sticky Add to Cart/Buy Now button on single product page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Enable', 'pressmart' ),
				'off'      		=> esc_html__( 'Disable', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'mobile-cart-page-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Cart Page Button', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Enable/Disable Sticky Proceed To Checkout button on cart page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Enable', 'pressmart' ),
				'off'      		=> esc_html__( 'Disable', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'mobile-checkout-page-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Checkout Page Button', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Enable/Disable Sticky Place Order button on checkout page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Enable', 'pressmart' ),
				'off'      		=> esc_html__( 'Disable', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       	=> 'mobile-navbar-elements',
                'type'     	=> 'sorter',
                'title'    	=> esc_html__( 'Navbar Elements', 'pressmart' ),
                'compiler' 	=> 'true',
                'options'  	=> array(
                    'enabled'  => array(
						'shop'  		=> esc_html__( 'Shop', 'pressmart' ),
						'sidebar'  		=> esc_html__( 'Sidebar/Filters', 'pressmart' ),
						'wishlist' 		=> esc_html__( 'Wishlist', 'pressmart' ),
						'cart'     		=> esc_html__( 'Cart', 'pressmart' ),
						'account'  		=> esc_html__( 'Account', 'pressmart' ),
                    ),
                    'disabled' => array(						
                        'home'     		=> esc_html__( 'Home', 'pressmart' ),
						'menu'  		=> esc_html__( 'Menu', 'pressmart' ),
						'compare'  		=> esc_html__( 'Compare', 'pressmart' ),
						'search'  		=> esc_html__( 'Search', 'pressmart' ),
						'order'			=> esc_html__( 'Order', 'pressmart' ),
						'order-tracking'=> esc_html__( 'Order Tracking', 'pressmart' ),
						'blog'  		=> esc_html__( 'Blog', 'pressmart' ),
						'custom_link1'  => esc_html__( 'Custom Link 1', 'pressmart' ),
						'custom_link2'  => esc_html__( 'Custom Link 2', 'pressmart' ),
						'custom_link3'  => esc_html__( 'Custom Link 3', 'pressmart' ),
					),
                ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-shop',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Shop Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter shop navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Shop', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-shop',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Shop Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-home', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-home', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-wishlist',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Wishlist Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter wishlist navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Wishlist', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-wishlist',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Wishlist Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-heart', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-heart', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-cart',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Cart Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter cart navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Cart', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-cart',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Cart Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-handbag', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-handbag', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-account',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Account Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter account navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Account', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-account',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Account Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-user', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-user', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-home',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Home Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter home navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Home', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-home',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Home Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-home', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-home', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-menu',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Menu Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter menu navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Menu', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-menu',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Menu Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-menu', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-menu', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-compare',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Compare Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter compare navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Compare', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-compare',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Compare Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-shuffle', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-shuffle', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-filter',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Filter Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter filter navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Filters', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-filter',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Filter Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-equalizer', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-equalizer', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-order',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter order navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Order', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-order',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-letter', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-letter', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-order-tracking',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Tracking Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter order tracking navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Order Tracking', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-order-tracking',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Order Tracking Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-plane', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-plane', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-sidebar',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Sidebar Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter sidebar navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Sidebar', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-sidebar',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Sidebar Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-sidebar', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-sidebar', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-blog',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Blog Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter blog navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Blog', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-blog',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Blog Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-note', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-note', 'pressmart' ),
            ),
			
			array(
                'id'       			=> 'mobile-navbar-label-search',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Search Label', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter blog navbar label', 'pressmart' ),
				'default'  			=> esc_html__( 'Search', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-label-icon-search',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Search Label Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Enter pls font icon class. Ex. picon-magnifier', 'pressmart' ),
				'default'  			=> esc_html__( 'picon-magnifier', 'pressmart' ),
            ),
			array(
                'id'    => 'custom-link-options',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Custom Links', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link1-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 1 Label','pressmart'),
                'subtitle'     		=> esc_html__('Enter custom link 1 label.','pressmart'),
				'default'  			=> esc_html__( 'Custom 1', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link1-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 1 Icon','pressmart'),
                'subtitle'     		=> esc_html__('Enter pls font icon class.','pressmart'),
				'default'  			=> 'picon-home',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link1-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 1 URL','pressmart'),
                'subtitle'     		=> esc_html__('Enter custom link 1 url.','pressmart'),
				'default'  			=> '#',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link2-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 2 Label','pressmart'),
                'subtitle'     		=> esc_html__('Enter custom link 2 label.','pressmart'),
				'default'  			=> esc_html__( 'Custom 2', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link2-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 2 Icon','pressmart'),
                'subtitle'     		=> esc_html__('Enter pls font icon class.','pressmart'),
				'default'  			=> 'picon-home',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link2-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 2 URL','pressmart'),
                'subtitle'     		=> esc_html__('Enter custom link 2 url.','pressmart'),
				'default'  			=> '#',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link3-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 3 Label','pressmart'),
                'subtitle'     		=> esc_html__('Enter custom link 3 label.','pressmart'),
				'default'  			=> esc_html__( 'Custom 3', 'pressmart' ),
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link3-icon',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 3 Icon','pressmart'),
                'subtitle'     		=> esc_html__('Enter pls font icon class.','pressmart'),
				'default'  			=> 'picon-home',
            ),
			array(
                'id'       			=> 'mobile-navbar-custom-link3-url',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Custom Link 3 URL','pressmart'),
                'subtitle'     		=> esc_html__('Enter custom link 3 url.','pressmart'),
				'default'  			=> '#',
            ),
		)
	) );
	
	/*
	* Mobile colors
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Colors', 'pressmart' ),
        'id'         	=> 'section-mobile-colors',
		'subsection'   	=> true,
        'fields'     	=> array(
			array(
                'id'    => 'header-mobile-notice',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Mobile Header Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'header-mobile-background',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Background', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Mobile header background color.', 'pressmart' ),
                'default'  		=> '#ffffff',
            ),	
			array(
                'id'       		=> 'header-mobile-text-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Mobile header text color.', 'pressmart' ),
                'default'  		=> '#545454',
            ),			
			array(
                'id'       		=> 'header-mobile-link-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Mobile header link and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#333333',
                    'hover'   	=> '#059473',
                )
            ),
			array(
                'id'       => 'header-mobile-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'pressmart' ),                
                'subtitle' 		=> esc_html__( 'Mobile  header border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
			array(
                'id'       		=> 'header-mobile-input-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Input Field Color', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  		=> '#545454',
            ),
			array(
                'id'       		=> 'header-mobile-input-background',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Input Field Background', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  		=> '#ffffff',
            ),
			array(
				'id'       		=> 'google-theme-color',
				'type'     		=> 'color',
				'title'    		=> esc_html__( 'Google Theme Color', 'pressmart' ), 				
				'subtitle'   		=> wp_kses( sprintf( __( 'Applied only on mobile devices Android on chrome browser toolbar, <a href="%s" target="_blank">click here</a> plugin.', 'pressmart' ), esc_url( 'http://updates.html5rocks.com/2014/11/Support-for-theme-color-in-Chrome-39-for-Android/' ) ),
				array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'validate' 		=> 'color',
				'default'  		=> '#FFFFFF'
			),
		),
	) );
	
	/*
	* Theme Typography
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Typography', 'pressmart' ),
        'id'         => 'section-typography',
		'icon'		 => 'el el-font',
        'fields'     => array(
			array(
				'id'          		=> 'body-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Primary Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'color'  			=> false,
				'letter-spacing' 	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use primary font for all title, body text, etc...', 'pressmart' ),
				'output' 			=> array( 'body,body .compare-list' ),
				'default'     		=> array(
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '14px',
					'letter-spacing'	=> '',
				),
			),
			array(
				'id'          		=> 'secondary-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Secondary Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'font-size'   		=> false,
				'letter-spacing' 	=> false,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use secondary font for secondary(alt) titles.', 'pressmart' ),
				'output' 			=> array( '.secondary-font' ),
				'default'     		=> array(
					'color'       		=> '#333333',
					'font-weight'  		=> '400', 
					'font-family' 		=> 'Satisfy', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
				),
			),			
			array(
				'id'          		=> 'h1-headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H1 Headings Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use H1 heading font for all H1 headings.', 'pressmart' ),
				'output' 			=> array( 'h1, .h1' ),
				'default'     		=> array(
					'color'       		=> '#333333', 
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '32px',
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'h2-headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H2 Headings Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use H2 heading font for all H2 headings.', 'pressmart' ),
				'output' 			=> array( 'h2, .h2' ),
				'default'     		=> array(
					'color'       		=> '#333333', 
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '28px',
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'h3-headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H3 Headings Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use H3 heading font for all H3 headings.', 'pressmart' ),
				'output' 			=> array( 'h3, .h3' ),
				'default'     		=> array(
					'color'       		=> '#333333', 
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '24px',
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'h4-headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H4 Headings Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use H4 heading font for all H4 headings.', 'pressmart' ),
				'output' 			=> array( 'h4, .h4' ),
				'default'     		=> array(
					'color'       		=> '#333333', 
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '20px',
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'h5-headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H5 Headings Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use H5 heading font for all H5 headings.', 'pressmart' ),
				'output' 			=> array( 'h5, .h5' ),
				'default'     		=> array(
					'color'       		=> '#333333', 
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '18px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'h6-headings-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'H6 Headings Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use H6 heading font for all H6 headings.', 'pressmart' ),
				'output' 			=> array( 'h6, .h6' ),
				'default'     		=> array(
					'color'       		=> '#333333', 
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '16px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'main-menu-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Main Menu Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'color'				=> false,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use this typography for header main navigation.', 'pressmart' ),
				'output' 			=> array( '.main-navigation ul.menu > li > a' ),
				'default'     		=> array(
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '14px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
			array(
				'id'          		=> 'categories-menu-font',
				'type'        		=> 'typography',
				'title'       		=> esc_html__( 'Categories Menu Font', 'pressmart' ),
				'all_styles'  		=> true,
				'font-backup' 		=> true,
				'color'				=> false,
				'text-align'  		=> false,
				'line-height' 		=> false,
				'letter-spacing' 	=> true,
				'text-transform'	=> true,
				'units'       		=>'px',
				'subtitle'    		=> esc_html__( 'Use this typography for categories parent menu.', 'pressmart' ),
				'output' 			=> array( '.categories-menu ul.menu > li > a' ),
				'default'     		=> array(
					'font-weight'  		=> '600', 
					'font-family' 		=> 'Poppins', 
					'google'      		=> true,
					'font-backup' 		=> 'Arial, Helvetica, sans-serif',
					'font-size'   		=> '14px', 
					'letter-spacing'	=> '',
					'text-transform'	=> 'inherit'
				),
			),
		),
	) );
	
	/*
	* Custom Fonts
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Custom Fonts', 'pressmart' ),
        'id'         	=> 'section-custom-font',
		'desc'  		=> esc_html__( 'After uploading your fonts,you will have to save Theme Settings and RELOAD this page , Then you should select font family (custom font family)from dropdown list in (Body/Paragraph/Headings/Navigation) Typography section.', 'pressmart' ),
        'subsection'   	=> true,
        'fields'     	=> array(
			array(
                'id'       			=> 'custom-font1',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Custom Font1', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Custom Font 1.', 'pressmart' ),
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
				'off'      			=> esc_html__( 'Disable', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'type'      		=> 'text',
                'id'        		=> 'custom-font1-name',
                'title'     		=> esc_html__( 'Font1 Name', 'pressmart' ),
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-woff',
                'title'     		=> esc_html__( 'Font1 (.woff)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-woff2',
                'title'     		=> esc_html__( 'Font1 (.woff2)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-ttf',
                'title'     		=> esc_html__( 'Font1 (.ttf)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-svg',
                'title'     		=> esc_html__( 'Font1 (.svg)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font1-eot',
                'title'     		=> esc_html__( 'Font1 (.eot)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font1', '=', '1' ),
            ),
			array(
                'id'       			=> 'custom-font2',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Custom Font2', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Custom Font 2.', 'pressmart' ),
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
				'off'      			=> esc_html__( 'Disable', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'type'      		=> 'text',
                'id'        		=> 'custom-font2-name',
                'title'     		=> esc_html__( 'Font2 Name', 'pressmart' ),
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-woff',
                'title'     		=> esc_html__( 'Font2 (.woff)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-woff2',
                'title'     		=> esc_html__( 'Font2 (.woff2)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-ttf',
                'title'     		=> esc_html__( 'Font2 (.ttf)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-svg',
                'title'     		=> esc_html__( 'Font2 (.svg)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font2-eot',
                'title'     		=> esc_html__( 'Font2 (.eot)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font2', '=', '1' ),
            ),
			array(
                'id'       			=> 'custom-font3',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Custom Font3', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Custom Font 3.', 'pressmart' ),
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
				'off'      			=> esc_html__( 'Disable', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'type'      		=> 'text',
                'id'        		=> 'custom-font3-name',
                'title'     		=> esc_html__( 'Font3 Name', 'pressmart' ),
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-woff',
                'title'     		=> esc_html__( 'Font3 (.woff)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-woff2',
                'title'     		=> esc_html__( 'Font3 (.woff2)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-ttf',
                'title'     		=> esc_html__( 'Font3 (.ttf)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-svg',
                'title'     		=> esc_html__( 'Font3 (.svg)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
			array(
                'type'      		=> 'media',
                'id'        		=> 'custom-font3-eot',
                'title'     		=> esc_html__( 'Font3 (.eot)', 'pressmart' ),
                'mode'       		=> false,
                'preview'  			=> false,
                'url'       		=> true,
                'required'  		=> array( 'custom-font3', '=', '1' ),
            ),
		),
	) );
	
	/*
	* Typekit Font
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Adobe Typekit Font', 'pressmart' ),
        'id'         	=> 'section-typekit-font',
        'subsection'   	=> true,
        'fields'     	=> array(
			array(
                'id'       			=> 'typekit-font',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Adobe Typekit Font', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Please enable this option to use Adobe Typekit.', 'pressmart' ),
                'on'       			=> esc_html__( 'Enable', 'pressmart' ),
				'off'      			=> esc_html__( 'Disable', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'   				=> 'typekit-kit-id',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Typekit Kit ID', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter your ', 'pressmart' ) . '<a target="_blank" href="https://typekit.com/account/kits">Typekit Kit ID</a>.',
				'required'  		=> array( 'typekit-font', '=', '1' ),
            ),
			array(
                'id'   				=> 'typekit-kit-family',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Typekit Font Family', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter all custom fonts you will use separated with coma.', 'pressmart' ),
				'required'  		=> array( 'typekit-font', '=', '1' ),
            ),
		),
	) );
	
	// Theme Styling Options
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Theme Styling', 'pressmart' ),
        'id'               => 'theme-styling',
        'desc'             => '',
        'icon'		 	   => 'el el-brush',
		'fields'           => array(
		)
	) );
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Body', 'pressmart' ),
        'id'         => 'body-styling',
        'subsection' => true,		
        'fields'     => array(
            array(
                'id'       		=> 'primary-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Primary Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Primary color', 'pressmart' ),
                'default'  		=> '#059473',
            ),
			array(
				'id'       		=> 'primary-inverse-color',
				'type'     		=> 'color',
				'title'    		=> esc_html__( 'Primary Inverse Color', 'pressmart' ), 
				'subtitle' 		=> esc_html__( 'Primary inverse color', 'pressmart' ),
				'validate' 		=> 'color',
				'default'  		=> '#ffffff'
			),
			array(
                'id'       		=> 'secondary-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Secondary Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Secondary color', 'pressmart' ),
                'default'  		=> '#059473',
            ),
			array(
				'id'       		=> 'secondary-inverse-color',
				'type'     		=> 'color',
				'title'    		=> esc_html__( 'Secondary Inverse Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Secondary inverse color', 'pressmart' ),
				'validate' 		=> 'color',
				'default'  		=> '#ffffff'
			),
			array(
				'id'       		=> 'theme-hover-background-color',
				'type'     		=> 'color',
				'title'    		=> esc_html__( 'Hover Background Color', 'pressmart' ), 
				'subtitle' 		=> esc_html__( 'Apply theme hover background color for ul li menu, list, etc...', 'pressmart' ),
				'validate' 		=> 'color',
				'default'  		=> '#f8f8f8'
			),
			array(
                'id'       		=> 'body-background',
                'type'     		=> 'background',
                'title'    		=> esc_html__( 'Body Background', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Body background image or color. Only for work in Boxed layout', 'pressmart' ),
				'output'   		=> array( 'body' ),
                'default' 		=> array(
								'background-color' 		=> '#ffffff',
								'background-image' 		=> '',
								'background-repeat' 	=> '',
								'background-size' 		=> '',
								'background-attachment' => '',
								'background-position' 	=> '',
							)
            ),
			array (
				'id'       		=> 'site-wrapper-background',
				'type'     		=> 'background',
				'title'    		=> esc_html__('Wrapper Background', 'pressmart'),
				'output' 		=> array('.site-wrapper'),
				'default'  		=> array(
					'background-color'	 	=> '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       		=> 'body-text-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Site text color.', 'pressmart' ),
                'default'  		=> '#545454',
            ),
			array(
                'id'       		=> 'body-link-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Site link and hover color.', 'pressmart' ),
				'active'   		=> false,
                'default'  		=> array(
                    'regular' => '#212121',
                    'hover'   => '#059473',
                )
            ),
			array(
                'id'       		=> 'theme-border',
                'type'     		=> 'border',
                'title'    		=> esc_html__( 'Border', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Site border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
			array(
                'id'            => 'theme-border-radius',
                'type'          => 'slider',
                'title'         => esc_html__( 'Border Radius', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'site border radius.', 'pressmart' ),
                'default'       => 0,
                'min'           => 0,
                'step'          => 1,
                'max'           => 10,
                'display_value' => 'label'
            ),			
			array(
                'id'       => 'body-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background', 'pressmart' ),
                'subtitle' => esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'       => 'body-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),	
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Topbar', 'pressmart' ),
        'id'         => 'topbar-styling',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'       	=> 'topbar-background',
                'type'     	=> 'background',
                'title'    	=> esc_html__( ' Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Topbar background image or color.', 'pressmart' ),
				'output' 	=> array( '.header-topbar' ),
				'default'  		=> array(
					'background-color'	 	=> '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
            ),
            array(
                'id'       => 'topbar-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Topbar text color', 'pressmart' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'topbar-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Topbar link and hover color.', 'pressmart' ),
				'active'    	=> false,
                'default'  => array(
                    'regular' => '#212121',
                    'hover'   => '#059473',
                )
            ),
			array(
                'id'       => 'topbar-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'pressmart' ),                
                'subtitle' 		=> esc_html__( 'Topbar border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
			array(
                'id'       => 'topbar-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color( TextBox, SelectBox, etc..)', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),
			 array(
                'id'       => 'topbar-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background( TextBox, SelectBox, etc..)', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'          		=> 'topbar-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Max Height', 'pressmart' ),
				'subtitle'    		=> esc_html__( 'Set max height for topbar.', 'pressmart' ),
                'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 42,
                )
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Header', 'pressmart' ),
        'id'         => 'header-styling',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'    => 'header-notice1',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Header Colors', 'pressmart' ),
            ),
			array(
                'id'       => 'header-background',
                'type'     => 'background',
                'title'    => esc_html__( 'Background', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Header background image or color', 'pressmart' ),
				'output' 		=> array( '.header-main' ),
                'default' => array(
								'background-color' => '#ffffff',
								'background-image' 		=> '',
								'background-repeat' 	=> '',
								'background-size' 		=> '',
								'background-attachment' => '',
								'background-position' 	=> '',
							)
            ),
            array(
                'id'       => 'header-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Header text color', 'pressmart' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'header-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Header link and hover color.', 'pressmart' ),
				'active'   => false,
                'default'  => array(
                    'regular' => '#212121',
                    'hover'   => '#059473',
                )
            ),
			array(
                'id'       => 'header-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Header border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
			array(
                'id'       => 'header-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'header-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'          		=> 'header-min-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Min Height', 'pressmart' ),
				'subtitle'    		=> esc_html__( 'Set min height for header.', 'pressmart' ),
				'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 92,
                )
            ),
			
			array(
                'id'    => 'header-notice2',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Header Transparent Colors', 'pressmart' ),
            ),
			array(
                'id'       			=> 'header-transparent-color',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Header Transparent Color', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'This color will work when header transparent/overlay enable.', 'pressmart' ),
                'options'  			=> array(
                    'light' 	=> esc_html__( 'Light', 'pressmart' ),
                    'dark' 		=> esc_html__( 'Dark', 'pressmart' ),
                ),
                'default'  			=> 'light',
            ),
		)
	) );
		
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Navigation', 'pressmart' ),
        'id'         => 'navigation-styling',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'navigation-background',
                'type'     => 'background',
                'title'    => esc_html__( 'Background Color', 'pressmart' ),
				'subtitle' 	=> esc_html__( 'Navigation bar background image or color', 'pressmart' ),
				'output' 	=> array( '.header-navigation' ),
                'default'  => array(
					'background-color' 		=> '#059473',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
            array(
                'id'       => 'navigation-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Navigation bar text color', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'       => 'navigation-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' 	=> esc_html__( 'Navigation bar link and hover color.', 'pressmart' ),
				'active'   => false,
                'default'  => array(
                    'regular' => '#ffffff',
                    'hover'   => '#ffffff',
                )
            ),			 
			array(
                'id'       => 'navigation-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Navigation Border', 'pressmart' ),
                'subtitle' => esc_html__( 'Navigation bar border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#059473',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),	
			array(
                'id'       => 'navigation-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),		
			array(
                'id'       => 'navigation-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background', 'pressmart' ),
                'subtitle' => esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),	
			array(
                'id'          		=> 'navigation-min-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Min Height', 'pressmart' ),
				'subtitle'    		=> esc_html__( 'Set min height for navigation bar.', 'pressmart' ),
                'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 44,
                )
            ),	
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Menu & Categories Menu', 'pressmart' ),
        'id'         => 'menu-styling',
        'subsection' => true,
        'fields'     => array(
			/*array(
                'id'    => 'frist-level-menu-notice',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'First Level Menu Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'first-level-menu-background-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Hover Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'First level menu hover background color', 'pressmart' ),
                'default'  		=> 'transparent',
            ),		
			array(
                'id'       		=> 'first-level-menu-link-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'First level menu link and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#ffffff',
                )
            ),*/
			array(
                'id'    => 'categories-menu-title-notice',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Categories Menu Title Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'categories-menu-title-background',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Categories menu title background color', 'pressmart' ),
                'validate' 		=> 'color',
                'default' 		=> '#048567',
            ),		
			array(
                'id'       		=> 'categories-menu-title-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Title Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Categories menu title color.', 'pressmart' ),
                'active'    	=> false,
                'default' 		=> '#ffffff',
            ),
			array(
                'id'    => 'categories-menu-notice',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Categories Area & Menu Colors', 'pressmart' ),
            ),
			array (
				'id'       		=> 'categories-menu-wrapper-background',
				'type'     		=> 'color',
				'title'    		=> esc_html__( 'Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Categories menu wrapper/area background color', 'pressmart' ),
				'default'  		=> '#ffffff',
			),
			array(
                'id'       		=> 'categories-menu-hover-background',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Hover Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Categories menu hover background color', 'pressmart' ),
                'validate' 		=> 'color',
                'default' 		=> '#f8f8f8',
            ),
			array(
                'id'       		=> 'categories-menu-link-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Categories menu link and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#212121',
                    'hover'   	=> '#059473',
                )
            ),
			array(
                'id'       		=> 'categories-menu-border',
                'type'     		=> 'border',
                'title'   	 	=> esc_html__( 'Border', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Categories menu border color, style and width.', 'pressmart' ),
                'default'  		=> array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
					'border-top'    => '1px',
					'border-right'  => '1px',
					'border-bottom' => '1px',
					'border-left'   => '1px'
                )
            ),
			array(
                'id'    => 'menu-popup-notice',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Main & Categories menu Popup Colors', 'pressmart' ),
            ),
			array (
				'id'       		=> 'popup-menu-background',
				'type'     		=> 'background',
				'title'    		=> esc_html__( 'Background', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Popup menu background image or color', 'pressmart' ),
				'output' 		=> array( '.pressmart-navigation ul.menu ul.sub-menu, .pressmart-navigation .pressmart-megamenu-wrapper' ),
				'default'  		=> array(
					'background-color'	 => '#ffffff',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       		=> 'popup-menu-hover-background',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Hover Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Popup menu hover background color', 'pressmart' ),
                'validate' 		=> 'color',
                'default' 		=> '#f8f8f8',
            ),
			array(
                'id'       		=> 'popup-menu-text-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Popup menu text color', 'pressmart' ),
                'default'  		=> '#545454',
            ),			
			array(
                'id'       		=> 'popup-menu-link-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Popup menu link and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#212121',
                    'hover'   	=> '#059473',
                )
            ),
			array(
                'id'       		=> 'popup-menu-border',
                'type'     		=> 'border',
                'title'   	 	=> esc_html__( 'Border', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Popup menu border color, style and width.', 'pressmart' ),
                'default'  		=> array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
					'border-top'    => '1px',
					'border-right'  => '1px',
					'border-bottom' => '1px',
					'border-left'   => '1px'
                )
            ),			
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page Heading', 'pressmart' ),
        'id'         => 'page-heading-style',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'page-heading-background',
                'type'     => 'background',
                'title'    =>  esc_html__( 'Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Page title background image or color', 'pressmart' ),
				'output' 		=> array( '#page-title' ),
                'default' => array(
					'background-color' => '#f8f8f8',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> 'cover',
					'background-attachment' => '',
					'background-position' 	=> 'center center'
				),
            ),
			array(
                'id'       			=> 'page-title-color',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Title Color', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Page title color.', 'pressmart' ),
                'options'  			=> array(
                    'default' 	=> esc_html__( 'Default', 'pressmart' ),
                    'light' 	=> esc_html__( 'Light', 'pressmart' ),
                    'dark' 		=> esc_html__( 'Dark', 'pressmart' ),
                ),
                'default'  			=> 'dark',
            ),
			array(
                'id'       			=> 'page-title-size',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Title Size', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Page title size.', 'pressmart' ),
                'options'  			=> array(
                    'default' 		=> esc_html__( 'Default', 'pressmart' ),
                    'small' 		=> esc_html__( 'Small', 'pressmart' ),
                    'large' 		=> esc_html__( 'Large', 'pressmart' ),
                ),
                'default'  			=> 'default',
            ),
			array(
				'id'             	=> 'page-title-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'pressmart' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for page title.', 'pressmart' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '#page-title' ),
				'default'            => array(
					'padding-top'     	=> '50', 
					'padding-bottom'  	=> '50',
					'units'          	=> 'px', 
				)
			),
		)
	) );
		
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer', 'pressmart' ),
        'id'         => 'footer-styling',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'    => 'footer-notice1',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Footer Colors', 'pressmart' ),
            ),			
			array(
                'id'       		=> 'footer-background',
                'type'     		=> 'background',
                'title'    		=> esc_html__( 'Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Footer background image or color', 'pressmart' ),
				'output'  	 	=> array( '.site-footer .footer-main, .site-footer .footer-categories' ),
                'default' 		=> array(
					'background-color' 		=> '#f8f8f8',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
			array(
                'id'       => 'footer-heading-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Heading Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Footer heading color like widget, etc.', 'pressmart' ),
                'default'  => '#212121',
            ),
            array(
                'id'       => 'footer-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' => esc_html__( 'Footer text color', 'pressmart' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'footer-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Footer link and hover color.', 'pressmart' ),
				'active'   => false,
                'default'  => array(
                    'regular' => '#212121',
                    'hover'   => '#059473',
                )
            ),
			array(
                'id'       => 'footer-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'pressmart' ),
                'subtitle' => esc_html__( 'Footer border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),		
			array(
                'id'       => 'footer-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),	
			array(
                'id'       => 'footer-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background', 'pressmart' ),
                'subtitle' => esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'    => 'copyright-notice1',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Copyright Colors', 'pressmart' ),
            ),
			array(
                'id'       => 'copyright-background',
                'type'     => 'background',
                'title'    => esc_html__( 'Background Color', 'pressmart' ),
				'subtitle' => esc_html__( 'Copyright background image or color', 'pressmart' ),
				'output'   => array( '.site-footer .footer-copyright' ),
                'default'  => array(
					'background-color' => '#f8f8f8',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
            array(
                'id'       => 'copyright-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' => esc_html__( 'Copyright text color', 'pressmart' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'copyright-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Copyright link and hover color.', 'pressmart' ),
				'active'   => false,
                'default'  => array(
                    'regular' => '#212121',
                    'hover'   => '#059473',
                )
            ),
			array(
                'id'       => 'copyright-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Copyright Border', 'pressmart' ),
                'subtitle' => esc_html__( 'Copyright border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
		)
	) );
	
	/*
	* Buttons colors
	*/
	Redux::setSection( $opt_name, array(
        'title'      	=> esc_html__( 'Buttons', 'pressmart' ),
        'id'         	=> 'section-buttons',
		'subsection'   	=> true,
        'fields'     	=> array(
			array(
                'id'    => 'site-button-color-info',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Site Buttons Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button background and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#059473',
                    'hover'   	=> '#048567',
                )
            ),
			array(
                'id'       		=> 'button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button text color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
			
			//Shop Page Buttons Colors
			array(
                'id'    => 'shop-page-button-color-info',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Shop Page Buttons Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'shop-cart-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Add To Cart Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set add to cart button background and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#f5f5f5',
                    'hover'   	=> '#059473',
                )
            ),
			array(
                'id'       		=> 'shop-cart-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Add To Cart Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set add to cart button text color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#545454',
                    'hover'   	=> '#ffffff',
                )
            ),
			
			//Product Page Buttons Colors
			array(
                'id'    => 'product-page-button-color-info',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Product Page Buttons Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'product-cart-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Add To Cart Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set add to cart button background and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#059473',
                    'hover'   	=> '#048567',
                )
            ),
			array(
                'id'       		=> 'product-cart-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Add To Cart Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set add to cart button text color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
			array(
                'id'       		=> 'buy-now-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Buy Now Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set buy now button background and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#9e7856',
                    'hover'   	=> '#ae8866',
                )
            ),
			array(
                'id'       		=> 'buy-now-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Buy Now Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set buy now button text color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
			array(
                'id'    => 'checkout-button-color-info',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Checkout Buttons Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'checkout-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Checkout & Place Order Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set checkout button background and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#9e7856',
                    'hover'   	=> '#ae8866',
                )
            ),
			array(
                'id'       		=> 'checkout-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Checkout & Place Order Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set checkout button text color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
			
		),
	) );
	
	/*
	* Header
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Header', 'pressmart' ),
        'id'         => 'header',
		'icon'		 => 'el el-photo',
        'fields'     => array(
			array(
                'id'   				=> 'header-phone-number',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Phone Number', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide phone number on header.', 'pressmart' ),
				'default'  			=> '+(123) 4567 890',
            ),			
			array(
                'id'   				=> 'header-email',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Email Address', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide email address on header.', 'pressmart' ),
				'default'  			=> 'support@pressmart.com',
            ),
			array(
                'id'   				=> 'header-location',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Store Location', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide store location on header.', 'pressmart' ),
				'default'  			=> '123 Street, New York, US',
            ),
			array(
                'id'   				=> 'header-welcome-message',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Welcome Message', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide welcom message on header.', 'pressmart' ),
				'default'  			=> 'Welcome to Our Store!',
            ),
			array(
                'id'   				=> 'header-newsletter',
                'type'      		=> 'text',
                'title'     		=> esc_html__( 'Newsletter', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Leave empty for hide newsletter on header.', 'pressmart' ),
				'default'  			=> 'Newsletter',
            ),
			array(
                'id'       			=> 'header-language-switcher',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Language Switcher', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show language switcher on header topbar or not.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-currency-switcher',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Currency Switcher', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show currency switcher on header topbar or not.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'      			=> 'header-language-switcher-style',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Language Switcher Style', 'pressmart' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'This option will work if you have used <a href="%1$s" target="_blank">Polylang</a> Or <a href="%2$s" target="_blank">TranslatePress</a> plugin.', 'pressmart' ), esc_url( 'https://wordpress.org/plugins/polylang/' ),esc_url( 'https://wordpress.org/plugins/translatepress-multilingual/' ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
                'options'  			=> array(
					'dropdown'		=> esc_html__( 'Dropdown', 'pressmart' ),
                    'horizontal' 	=> esc_html__( 'Horizontal List', 'pressmart' ),
                ),
                'default'  			=> 'dropdown',
            ),
			array(
                'id'       			=> 'header-language-switcher-view',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Language Country', 'pressmart' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'This option will work if you have used <a href="%1$s" target="_blank">Polylang</a> Or <a href="%2$s" target="_blank">TranslatePress</a> plugin.', 'pressmart' ), esc_url( 'https://wordpress.org/plugins/polylang/' ),esc_url( 'https://wordpress.org/plugins/translatepress-multilingual/' ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
                'options'  			=> array(
					'both'		=> esc_html__( 'Flag & Name', 'pressmart' ),
                    'name' 		=> esc_html__( 'Name', 'pressmart' ),
                    'flag' 		=> esc_html__( 'Flag', 'pressmart' ),
                ),
                'default'  			=> 'both',
            ),			
			array(
				'id'       => 'header-myaccount',
                'type'     => 'switch',
                'title'    => esc_html__( 'My Account', 'pressmart' ),
                'subtitle'     => esc_html__( 'Show my account on header.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       			=> 'login-register-popup',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Login/Register Popup', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show header login/register popup.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-minicart-popup',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Mini Cart Popup', 'pressmart' ),
				'subtitle'     		=> esc_html__( 'Select header mini cart popup.', 'pressmart' ),
                'options'  			=> array(
                    'slider' 		=> esc_html__( 'Slider', 'pressmart' ),
                    'dropdow'		=> esc_html__( 'Dropdown', 'pressmart' ),
                    'none' 			=> esc_html__( 'None', 'pressmart' ),
                ),
                'default'  			=> 'slider',
            ),
			array(
                'id'       			=> 'header-cart-style',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Cart Style', 'pressmart' ),
				'subtitle' 	   		=> esc_html__( 'Select cart style.', 'pressmart' ),
                'options'  			=> array(					
					1	=> array(
                        'alt' 	=> '1',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/cart/1.jpg'
                    ),
                ),
                'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-cart-icon',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Cart Icon', 'pressmart' ),
				'subtitle' 	   		=> esc_html__( 'Select cart icon.', 'pressmart' ),
                'options'  			=> array(
					 'cart-icon'	=> array(
                        'alt' 		=> 'Icon Cart',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/cart/icon-1.jpg'
                    ),					
					'bag-icon' 		=> array(
                        'alt' 		=> 'Icon Bag',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/cart/icon-2.jpg'
                    ),                					
                ),
                'default'  			=> 'cart-icon',
            ),
			array(
                'id'       			=> 'header-wishlist',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Wishlist Icon', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show wishlist icon on header.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-compare',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Compare Icon', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show compare icon on header.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-icon-text',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Icon Text', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Show icon text on header.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       => 'categories-menu',
                'type'     => 'switch',
                'title'    => esc_html__( 'Categories Menu', 'pressmart' ),
                'subtitle'     => esc_html__( 'Show shopping categories menu on header or not.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'categories-menu-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Categories Menu Title', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter categories menu title.', 'pressmart' ),
				'default'  => 'Shopping By Categories',
            ),
			array(
                'id'       => 'open-categories-menu',
                'type'     => 'switch',
                'title'    => esc_html__( 'Categories(Vertical) Menu On Home Page', 'pressmart' ),
                'subtitle' => esc_html__( 'You always want to keep the categories (vertical) menu open on the home page.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
		)
	) );
	
	/*
	* Header Manager options
	*/
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Header Manager', 'pressmart' ),
        'id'         		=> 'header-manager',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'header-topbar',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Topbar', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show header topbar or not.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-transparent',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Transparent', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Make the header transparent/overlay the content.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-transparent-on',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Header Transparent On', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Make the header transparent/overlay the content on front page or all pages.', 'pressmart' ),
                'options'  			=> array(
                    'front-page' 	=> esc_html__( 'Front Page', 'pressmart' ),
                    'all-pages' 	=> esc_html__( 'All Pages', 'pressmart' ),
                ),
                'default'  			=> 'front-page',
				'required' 			=> array( 'header-transparent', '=', 1 ),
            ),
			array(
                'id'       			=> 'header-select',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Select Header', 'pressmart' ),
                'options'  			=> array(
                    'style' 		=> esc_html__( 'Header Style', 'pressmart' ),
                    'builder' 		=> esc_html__( 'Header Builder', 'pressmart' ),
                ),
                'default'  			=> 'style',
            ),
			array(
                'id'       			=> 'header-style',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Header Style', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Select a header style.', 'pressmart' ),
				'full_width' 		=> true,
				'options'  			=> array(
					'1' => array( 'title' => '1', 'alt' => 'Header 1', 'img' => PRESSMART_ADMIN_IMAGES.'header/header-1.png' ),
                    '2' => array( 'title' => '2', 'alt' => 'Header 2', 'img' => PRESSMART_ADMIN_IMAGES.'header/header-2.png' ),
                    '3' => array( 'title' => '3', 'alt' => 'Header 3', 'img' => PRESSMART_ADMIN_IMAGES.'header/header-3.png' ),
                    '4' => array( 'title' => '4', 'alt' => 'Header 4', 'img' => PRESSMART_ADMIN_IMAGES.'header/header-4.png' ),
                    '5' => array( 'title' => '5', 'alt' => 'Header 5', 'img' => PRESSMART_ADMIN_IMAGES.'header/header-5.png' ),
                ),
                'default'  			=> '1',				
				'required' 			=> array( 'header-select', '=', 'style' ),
            ),
			array(
                'id'    			=> 'header-topbar-info1',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Topbar Manager', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),			
			array(
                'id'       			=> 'header-topbar-manager',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Topbar Manager', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header topbar', 'pressmart' ),
				'full_width' 		=> true,
                'options'  			=> array(
                    'left'  	=> array(
						'email' 			=> esc_html__( 'Email', 'pressmart' ),
                        'phone-number'		=> esc_html__( 'Phone Number', 'pressmart' ),
                    ),
					'right' 	=> array(
						'welcome-message'	=> esc_html__( 'Welcome Message', 'pressmart' ),
						'language-switcher'	=> esc_html__( 'Language Switcher', 'pressmart' ),
						'currency-switcher'	=> esc_html__( 'Currency Switcher', 'pressmart' ),
					),
					'disabled' 	=> array(							
						'topbar-menu'		=> esc_html__( 'Topbar Menu', 'pressmart' ),
						'social-profile'	=> esc_html__( 'Social Profile', 'pressmart' ),
						'location'			=> esc_html__( 'Location', 'pressmart' ),
						'newsletter'		=> esc_html__( 'Newsletter', 'pressmart' ),
						'mini-search'		=> esc_html__( 'Mini Search', 'pressmart' ),
						/* 'topbar-widget'		=> 'Widget', */
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-topbar-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Topbar Left', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '6',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-topbar-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Topbar Right', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '6',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'    			=> 'header-main-info1',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Main Manager', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-main-manager',
                'type'     			=> 'sorter',
                'title'    			=> 'Header Main Manager',
				'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header main', 'pressmart' ),
				'full_width' 		=> true,
                'options'  			=> array(
                    'left'  	=> array(
                        'logo' 			=> esc_html__( 'Logo', 'pressmart' ),
                    ),
                    'center' 	=> array(
						'ajax-search'	=> esc_html__( 'Ajax Search', 'pressmart' ),
					),
					'right' 	=> array(
						'myaccount'			=> esc_html__( 'My Account', 'pressmart' ),					
						'wishlist'			=> esc_html__( 'Wishlist', 'pressmart' ),
						'cart'				=> esc_html__( 'Cart', 'pressmart' ),						
					),
					'disabled' 	=> array(
						'primary-menu'		=> esc_html__( 'Primary Menu', 'pressmart' ),
						'secondary-menu'	=> esc_html__( 'Secondary Menu', 'pressmart' ),
						'compare'			=> esc_html__( 'Compare', 'pressmart' ),	
						'mini-search'		=> esc_html__( 'Mini Search', 'pressmart' ),
						'currency-switcher'	=> esc_html__( 'Currency Switcher', 'pressmart' ),
						'language-switcher'	=> esc_html__( 'Language Switcher', 'pressmart' ),
						'customer-support'	=> esc_html__( 'Customer Support', 'pressmart' ),
						'custom-html'		=> esc_html__( 'Custom HTML', 'pressmart' ),
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-main-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Main Left', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '3',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-main-center',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Main Center', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '6',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'       			=> 'header-main-align',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Align Center', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Align center for above section.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-main-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Main Right', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '3',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'      			=> 'header-main-custom-html',
				'type'    		 	=> 'editor',
                'title'    			=> esc_html__( 'Custom HTML', 'pressmart' ),
				'default'  			=>'',
				'subtitle' 			=> esc_html__( 'Add your custom html here.', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'    			=> 'header-navigation-info1',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Navigation Manager', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-navigation',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Navigation', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show header navigation.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-navigation-manager',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Header Navigation Manager', 'pressmart' ),
                'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header navigation', 'pressmart' ),
				'full_width' 		=> true,
                'options'  			=> array(
                   'left'  		=> array(
                       'category-menu'		=> esc_html__( 'Category Menu', 'pressmart' ),
                    ),
                    'center' 	=> array(
						'primary-menu'			=> esc_html__( 'Primary Menu', 'pressmart' ),
					),
					'right' 	=> array(
					),
					'disabled' => array(
						'secondary-menu'	=> esc_html__( 'Secondary Menu', 'pressmart' ),	
						'ajax-search'		=> esc_html__( 'Ajax Search', 'pressmart' ),
						'myaccount'			=> esc_html__( 'My Account', 'pressmart' ),
						'cart'				=> esc_html__( 'Cart', 'pressmart' ),					
						'wishlist'			=> esc_html__( 'Wishlist', 'pressmart' ),
						'customer-support'	=> esc_html__( 'Customer Support', 'pressmart' ),
						'custom-html'		=> esc_html__( 'Custom HTML', 'pressmart' ),
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-navigation-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Navigation Left', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '3',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'       			=> 'header-navigation-center',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Navigation Center', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '9',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'       			=> 'header-navigation-align',
				'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Align Center', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Align center for above section.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-navigation-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Navigation Right', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
				'id'      			=> 'header-navigation-custom-html',
				'type'    		 	=> 'editor',
                'title'    			=> esc_html__( 'Custom HTML', 'pressmart' ),
				'default'  			=> '',
				'subtitle' 			=> esc_html__( 'Add your custom html here.', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
		)
	) );

	/*
	* Header Sticky Manager options
	*/
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Header Sticky Manager', 'pressmart' ),
        'id'         		=> 'header-sticky-manager',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'header-sticky',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Enable header sticky.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-sticky-part',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Make Header Sticky', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Select header section and make header sticky.', 'pressmart' ),
                'options'  			=> array(
					'topbar'		=>	esc_html__( 'Topbar', 'pressmart' ),
					'main'			=>	esc_html__( 'Middle(Main)', 'pressmart' ),
					'navigation'	=>	esc_html__( 'Navigation', 'pressmart' ),					
				),
                'default'  			=> 'main',
				'required' 			=> array( 'header-sticky', '=', 1 )
            ),
			array(
                'id'          		=> 'header-sticky-main-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Middle(Main) Height', 'pressmart' ),
				'subtitle'    		=> esc_html__( 'Set middle(|Main) header sticky height.', 'pressmart' ),
				'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array( 
                    'height' 		=> 65,
                ),
				'required' 			=> array( 'header-sticky-part', '=', 'main' ),
            ),	
			array(
                'id'       			=> 'header-sticky-scroll-up',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky Scroll-up', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show header sticky on scroll up.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
				'required' 			=> array( 'header-sticky', '=', 1 ),
            ),
		)
	) );
	
	/*
	* Header Mobile Manager options
	*/
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Header Mobile Manager', 'pressmart' ),
        'id'         		=> 'header-mobile',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       			=> 'header-sticky-tablet',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky On Tablet', 'pressmart' ),
                'subtitle' 	  		=> esc_html__( 'Header sticky on tablet width < 992px.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'header-sticky-mobile',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Header Sticky On Mobile', 'pressmart' ),
                'subtitle' 	 		=> esc_html__( 'Header sticky mobile width < 480px.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'          		=> 'header-mobile-height',
                'type'          	=> 'dimensions',
                'title'          	=> esc_html__( 'Height', 'pressmart' ),
				'subtitle'    		=> esc_html__( 'Set mobile header height.', 'pressmart' ),
				'units_extended'	=> false,
                'width'        	 	=> false,
                'default'        	=> array(
                    'height' 		=> 60,
                )
            ),			
			array(
                'id'    			=> 'header-mobile-topbar-info',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Mobile Topbar Manager', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),			
			array(
                'id'       			=> 'header-mobile-topbar-manager',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Header Mobile Topbar Manager', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header topbar', 'pressmart' ),
				'full_width' 		=> true,
                'options'  			=> array(
					'center' 	=> array(
						'welcome-message'	=> esc_html__( 'Welcome Message', 'pressmart' ),
						'language-switcher'	=> esc_html__( 'Language Switcher', 'pressmart' ),
						'currency-switcher'	=> esc_html__( 'Currency Switcher', 'pressmart' ),
					),
					'disabled' 	=> array(
						'email' 			=> esc_html__( 'Email', 'pressmart' ),
                        'phone-number'		=> esc_html__( 'Phone Number', 'pressmart' ),
						'topbar-menu'		=> esc_html__( 'Topbar Menu', 'pressmart' ),
						'social-profile'	=> esc_html__( 'Social Profile', 'pressmart' ),
						'location'			=> esc_html__( 'Location', 'pressmart' ),
						'newsletter'		=> esc_html__( 'Newsletter', 'pressmart' ),
						/* 'topbar-widget'		=> 'Widget', */
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),			
			array(
                'id'       			=> 'header-mobile-topbar-align',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Align Center', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show align center for mobile topbar section.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),			
			array(
                'id'    			=> 'header-mobile-main-info',
                'type'  			=> 'info',
				'notice' 			=> false,
                'title' 			=> esc_html__( 'Header Mobile Main Manager', 'pressmart' ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
                'id'       			=> 'header-mobile-manager',
                'type'     			=> 'sorter',
                'title'    			=> esc_html__( 'Header Mobile Manager', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Organize how you want the layout to appear on the header mobile', 'pressmart' ),
				'full_width' 		=> true,
                'options'  			=> array(
                    'left'  	=> array(
						'mobile-navbar'		=> esc_html__( 'Mobile Nav', 'pressmart' ),				
                    ),
					'center' 	=> array(
						'logo'				=> esc_html__( 'Logo', 'pressmart' ),
					),
					'right' 	=> array(
						'mini-search'		=> esc_html__( 'Mini Search', 'pressmart' ),
						'cart'				=> esc_html__( 'Cart', 'pressmart' ),
					),
					'disabled' 	=> array(
						'myaccount'			=> esc_html__( 'My Account', 'pressmart' ),
                        'wishlist'			=> esc_html__( 'Wishlist', 'pressmart' ),
					),
                ),
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-mobile-left',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Mobile Left', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '4',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			
			array(
				'id'       			=> 'header-mobile-center',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Mobile Center', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '4',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
			array(
                'id'       			=> 'header-mobile-align',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Align Center', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show Header Mobile Center section in align center.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
				'required' 			=> array( 'header-select', '=', 'builder' ),
            ),
			array(
				'id'       			=> 'header-mobile-right',
				'type'     			=> 'select',
				'title'    			=> esc_html__( 'Header Mobile Right', 'pressmart' ),
				'options' 			=> array(
					'1'  => esc_html__( '1 column - 1/12', 'pressmart' ),
					'2'  => esc_html__( '2 columns - 1/6', 'pressmart' ),
					'3'  => esc_html__( '3 columns - 1/4', 'pressmart' ),
					'4'  => esc_html__( '4 columns - 1/3', 'pressmart' ),
					'5'  => esc_html__( '5 columns - 5/12', 'pressmart' ),
					'6'  => esc_html__( '6 columns - 1/2', 'pressmart' ),
					'7'  => esc_html__( '7 columns - 7/12', 'pressmart' ),
					'8'  => esc_html__( '8 columns - 2/3', 'pressmart' ),
					'9'  => esc_html__( '9 columns - 3/4', 'pressmart' ),
					'10' => esc_html__( '10 columns - 5/6', 'pressmart' ),
					'11' => esc_html__( '11 columns - 11/12', 'pressmart' ),
					'12' => esc_html__( '12 columns - 1/1', 'pressmart' ),
				),
				'default'  			=> '4',
				'required' 			=> array( 'header-select', '=', 'builder' ),
			),
		)
	) );
	
	// Header Ajax Search
    Redux::setSection( $opt_name, array(
        'title'     	 	=> esc_html__( 'Ajax Search', 'pressmart' ),
        'id'         		=> 'header-ajax-search',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       => 'header-search',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Header Search', 'pressmart' ),
                'subtitle'     => esc_html__( 'Enable/Disable header search.', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'product-ajax-search',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Live/Ajax Search', 'pressmart' ),
                'subtitle'     => esc_html__( 'Live product search or not on header.', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       			=> 'header-ajax-search-style',
                'type'     			=> 'image_select',
                'title'    			=> esc_html__( 'Ajax Search Style', 'pressmart' ),
				'subtitle' 	   		=> esc_html__( 'Select ajax search box style.', 'pressmart' ),
                'options'  			=> array(
					'ajax-search-style-1' 	=> array(
                        'alt' 	=> '1',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/search/1.png'
                    ), 
					'ajax-search-style-2' 	=> array(
                        'alt' 	=> '2',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/search/2.png'
                    ), 
					'ajax-search-style-3' 	=> array(
                        'alt' 	=> '2',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/search/3.png'
                    ), 
					'ajax-search-style-4' 	=> array(
                        'alt' 	=> '2',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/search/4.png'
                    ), 
                ),
                'default'  			=> 'ajax-search-style-1',
            ),
			array(
                'id'       			=> 'ajax-search-shape',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Ajax Search Shape', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Select ajax search box shape.', 'pressmart' ),
                'options'  			=> array(
                    'ajax-search-square'	=> esc_html__( 'Square', 'pressmart' ),
                    'ajax-search-radius' 	=> esc_html__( 'Radius', 'pressmart' ),
                ),
                'default'  			=> 'ajax-search-square',
            ),
			array(
                'id'       			=> 'search-content-type',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Search Content Type', 'pressmart' ),
				'subtitle'     		=> esc_html__( 'Select content type you want to use in the search box.', 'pressmart' ),
                'options'  			=> array(
                    'all'			=> esc_html__( 'All', 'pressmart' ),
                    'product' 		=> esc_html__( 'Product', 'pressmart' ),
                    'post' 			=> esc_html__( 'Post', 'pressmart' ),
                    'portfolio' 	=> esc_html__( 'Portfolio', 'pressmart' ),
                ),
                'default'  			=> 'product',
            ),
			array(
                'id'       => 'show-categories-dropdow',
                'type'     => 'switch',
                'title'    => esc_html__( 'Categories Dropdown', 'pressmart' ),
                'subtitle' 	   => esc_html__( 'Show categories dropdow in product search.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'search-categories',
                'type'     => 'radio',
                'title'    => esc_html__( 'Search Categories Dropdown', 'pressmart' ),
                'subtitle'     => esc_html__( 'Display categories in search categories dropdow.', 'pressmart' ),
                'options'  => array(
								'all' 	 => esc_html__( 'Show All Categories', 'pressmart' ),
								'parent' => esc_html__( 'Only Parent(top level) Categories', 'pressmart' ),
							),
				'default'  => 'all',
				'required' => array( 'show-categories-dropdow', '=', 1 ),
            ),
			array(
                'id'       => 'categories-hierarchical',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Categories Hierarchical', 'pressmart' ),
                'subtitle' 	   => esc_html__( 'Show categories in hierarchical (Must be need to select above option Show All Categories).', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'search-categories', '=', 'all' )
            ),
			array(
                'id'       			=> 'search-placeholder-text',
                'type'     			=> 'text',
                'title'    			=> esc_html__('Search Palceholder Text', 'pressmart' ),
                'subtitle'     		=> esc_html__('Enter search palceholder text', 'pressmart' ),
				'default'  			=> esc_html__('Search for products, categories, brands, sku...', 'pressmart' ),
            ),
			array(
                'id'       			=> 'header-search-image',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Search Image', 'pressmart' ),
                'subtitle' 	   		=> esc_html__('Show product Image in search results.', 'pressmart' ),
                'on'       			=> esc_html__('Yes', 'pressmart' ),
				'off'      			=> esc_html__('No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-search-price',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Search Price', 'pressmart' ),
                'subtitle' 	   		=> esc_html__('Show product price in search results.', 'pressmart' ),
                'on'       			=> esc_html__('Yes', 'pressmart' ),
				'off'      			=> esc_html__('No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'header-search-rating',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Search Rating', 'pressmart' ),
                'subtitle' 	   		=> esc_html__('Show product raing in search results.', 'pressmart' ),
                'on'       			=> esc_html__('Yes', 'pressmart' ),
				'off'      			=> esc_html__('No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'trending-search',
                'type'     			=> 'switch',
                'title'    			=> esc_html__('Trending Search', 'pressmart' ),
                'subtitle' 	   		=> esc_html__('Enable trending search.It will show when focus on search box.', 'pressmart' ),
                'on'       			=> esc_html__('Yes', 'pressmart' ),
				'off'      			=> esc_html__('No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
				'id'       			=> 'trending-search-categories',
				'type'     			=> 'select',
				'multi'    			=> true,
				'data' 	   			=> 'terms',
				'args' 				=> array( 'taxonomies'=>'product_cat' ),
				'title'    			=> esc_html__('Trending Categories', 'pressmart' ),
				'subtitle'     		=> esc_html__( 'Select your trending search categories.', 'pressmart' ),
				'placeholder' 		=> esc_attr__('Choose product categories', 'pressmart' ),
				'required' 			=> array( 'trending-search', '=', 1),
			),
		)
	) );
	
	/*
	* Page Heading options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page Heading', 'pressmart' ),
        'id'         => 'page-heading',
		'icon'		 => 'el el-icon-website',
        'fields'     => array(
			array(
                'id'       		=> 'page-title-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Title Layout', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select page title layout.Disable for hide title area', 'pressmart' ),
                'options'  		=> array(
                    'left' => array(
                        'title' 	=> 'Default',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/page-title-default.png',
                    ),
					'center' => array(
                        'title' 	=> 'Centered',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/page-title-centered.png',
                    ),
					'disable' => array(
                        'title' 	=> 'Disable',
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/page-title-none.png',
                    )
                ),
                'default'  		=> 'center',
            ),
			array(
                'id'       		=> 'page-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Title', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show/Hide page title.', 'pressmart' ),
                'default'  		=> 1,
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
                'off'      		=> esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'       		=> 'page-breadcrumb',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Breadcrumbs', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Show/Hide the breadcrumbs.', 'pressmart' ),
                'default'  		=> 1,
                'on'      		=> esc_html__( 'Show', 'pressmart' ),
                'off'      		=> esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'       		=> 'breadcrumbs-delimiter',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Breadcrumbs Delimiter', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select breadcrumb seperator', 'pressmart' ),
                'options'  		=> array(
                    'forward-slash' 	=> esc_html__( '/', 'pressmart' ),
                    'greater-than'		=> esc_html__( '>', 'pressmart' ),
                ),
                'default'  		=> 'forward-slash',
            ),			
		)
	) );
	
	//Footer Options
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer', 'pressmart' ),
        'id'         => 'footer',
		'icon'		 => 'el el-photo',
        'fields'     => array(
			array(
                'id'       		=> 'site-footer',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Footer', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show website footer.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			
			array(
                'id'       		=> 'footer-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Footer Layout', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select footer layout.', 'pressmart' ),
                'options'  		=> array(
                    '1' => array(
                        'title' 	=> esc_html__( '1', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-1.png',
                        'alt' 		=> esc_html__( 'Layout 1', 'pressmart' ),
                    ),
					'2' => array(
                        'title' 	=> esc_html__( '2', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-2.png',
                        'alt' 		=> esc_html__( 'Layout 2', 'pressmart' ),
                    ),
					'3' => array(
                        'title' 	=> esc_html__( '3', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-3.png',
                        'alt' 		=> esc_html__( 'Layout 3', 'pressmart' ),
                    ),
					'4' => array(
                        'title' 	=> esc_html__( '4', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-4.png',
                        'alt' 		=> esc_html__( 'Layout 4', 'pressmart' ),
                    ),					
					'5' => array(
                        'title' 	=> esc_html__( '5', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-5.png',
                        'alt' 		=> esc_html__( 'Layout 5', 'pressmart' ),
                    ),
					'6' => array(
                        'title' 	=> esc_html__( '6', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-6.png',
                        'alt' 		=> esc_html__( 'Layout 6', 'pressmart' ),
                    ),
					'7' => array(
                        'title' 	=> esc_html__( '7', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/footer-7.png',
                        'alt' 		=> esc_html__( 'Layout 7', 'pressmart' ),
                    ),
                ),
                'default'  			=> '2',
				'required'			=> array( 'site-footer', '=', 1 )
            ),
			array(
				'id'             	=> 'footer-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'pressmart' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for footer section.', 'pressmart' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'units'          	=> array('rem', '%', 'px'),
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.site-footer .footer-main' ),
				'default'            => array(
					'padding-top'     	=> '4', 
					'padding-bottom'  	=> '4',
					'units'          	=> 'rem', 
				)
			),
			array(
                'id'       		=> 'footer-widget-collapse',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Collapse Widgets on Mobile', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Yes/No collapse footer widgets on mobile device.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
				'required'		=> array( 'site-footer', '=', 1 )
            ),
		)
	) );	
	
	/*
	* Footer Subscribe
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Subscribe', 'pressmart' ),
        'id'         		=> 'section-footer-subscribe',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       		=> 'footer-subscribe',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Subscribe', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show subscribe section in footer.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0
            ),
			array(
                'id'       		=> 'footer-subscribe-layout',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Layout', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select subscribe layout.', 'pressmart' ),
                'options'  		=> array(
                    'columns' 		=> esc_html__( '2 Columns', 'pressmart' ),
                    'centered'		=> esc_html__( 'Centered', 'pressmart' ),
                ),
                'default'  		=> 'columns',
				'required'		=> array( 'footer-subscribe', '=', 1 )
            ),
			array(
                'id'       		=> 'footer-subscribe-title',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Title', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Enter subscribe title.', 'pressmart' ),
				'default'  		=> esc_html__( ' Subscribe to Our Newsletter', 'pressmart'),
				'required'		=> array( 'footer-subscribe', '=', 1 )
            ),
			array(
                'id'       		=> 'footer-subscribe-subtitle',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Subtitle', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Enter subscribe subtitle.', 'pressmart' ),
				'default'  		=> esc_html__( 'Subscribe today and get special offers, coupons and news.', 'pressmart'),
				'required'		=> array( 'footer-subscribe', '=', 1 )
            ),
			array(
                'id'       		=> 'subscribe-form-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Subscribe Form Style', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Select subscribe form style.', 'pressmart' ),
				'options'  		=> array(
                    'overlay-form' 		=> array(
                        'title' 	=> esc_html__( 'Overlay Form', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/overlay-form.png',
                    ),
                    'simple-form' 		=> array(
                        'title' 	=> esc_html__( 'Simple Form', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/subscribe-form.png',
                    ),
                ),
                'default'  		=> 'overlay-form',
				'required'		=> array( 'footer-subscribe', '=', 1 )
            ),
			array(
                'id'       		=> 'subscribe-field-shape',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Field Shape', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Select subscribe form field shape.', 'pressmart' ),
                'options'  		=> array(
					'shape-round' 	=> esc_html__( 'Round', 'pressmart' ),
                    'shape-square' 	=> esc_html__( 'Square', 'pressmart' ),
                ),
                'default'  		=> 'shape-round',
				'required'		=> array( 'footer-subscribe', '=', 1 )
            ),
			/* array(
                'id'       			=> 'footer-subscribe-style',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Subscribe Input Style', 'pressmart' ),
				'subtitle'     		=> esc_html__( 'Select subscribe textbox and button shape style.', 'pressmart' ),
                'options'  			=> array(
                    'default'	=> esc_html__( 'Default', 'pressmart' ),
                    'rounded' 	=> esc_html__( 'Rounded', 'pressmart' ),
                    'round' 	=> esc_html__( 'Round', 'pressmart' ),
                ),
                'default'  			=> 'round',
				'required'		=> array( 'footer-subscribe', '=', 1 )
            ), */
			array(
                'id'    => 'subscribe-notice',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Subscribe Colors', 'pressmart' ),
            ),
			array (
				'id'       		=> 'footer-subscribe-background',
				'type'     		=> 'background',
				'title'    		=> esc_html__( 'Background', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Footer subscribe background image or color', 'pressmart' ),
				'output' 		=> array( '.footer-subscribe' ),
				'default'  		=> array(
					'background-color'	 	=> '#059473',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> ''
				),
			),
			array(
                'id'       => 'footer-subscribe-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),	
			array(
                'id'       		=> 'subscribe-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button text color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#f1f1f1',
                )
            ),
			array(
                'id'       		=> 'subscribe-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Background Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button background color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#9e7856',
                    'hover'   	=> '#9e7856',
                )
            ),
			array(
                'id'       => 'footer-subscribe-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color', 'pressmart' ),
                'subtitle' => esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),	
			array(
                'id'       => 'footer-subscribe-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background', 'pressmart' ),
                'subtitle' => esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
				'id'             	=> 'footer-subscribe-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'pressmart' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for footer subscribe section.', 'pressmart' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'units'          	=> array('rem', '%', 'px'),
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.footer-subscribe' ),
				'default'            => array(
					'padding-top'     	=> '3', 
					'padding-bottom'  	=> '3',
					'units'          	=> 'rem', 
				)
			),
		)
	) );
	
	/*
	* Footer Link
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Footer Categories', 'pressmart' ),
        'id'         		=> 'section-footer-link',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       		=> 'footer-categories',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Footer Categories', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show popular categories in footer.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0
            ),			
			array(
				'id'       			=> 'footer-popular-categories',
				'type'     			=> 'select',
				'multi'    			=> true,
				'data' 	   			=> 'terms',
				'args' 				=> array( 'taxonomies'=>'product_cat' ),
				'title'    			=> esc_html__('Select Categories', 'pressmart' ),
				'subtitle'     		=> esc_html__( 'Please select parent category these have child categories.', 'pressmart' ),
				'placeholder' 		=> esc_attr__('Choose product categories', 'pressmart' ),
				'required' 			=> array( 'footer-categories', '=', 1),
			),
		)
	) );
	/*
	* Footer Copyright
	*/
	Redux::setSection( $opt_name, array(
        'title'      		=> esc_html__( 'Footer Copyright', 'pressmart' ),
        'id'         		=> 'section-footer-copyright',
		'subsection'		=> true,
        'fields'     		=> array(
			array(
                'id'       		=> 'footer-copyright',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Copyright', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show website copyright.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1
            ),
			array(
                'id'       		=> 'copyright-layout',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Copyright Layout', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select copyright layout.', 'pressmart' ),
                'options'  		=> array(
                    'columns' 		=> esc_html__( 'Columns', 'pressmart' ),
                    'centered'		=> esc_html__( 'Centered', 'pressmart' ),
                ),
                'default'  		=> 'columns',
				'required'		=> array( 'footer-copyright', '=', 1 )
            ),
			array(
                'id'       => 'copyright-text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Copyright', 'pressmart' ),
				'subtitle' => esc_html__( 'Enter copyright text. Use {current_year} for get dynamic current year.', 'pressmart' ),
				'default'  => wp_kses( sprintf( __( 'PressMart &copy; {current_year} by <a href="%s" target="_blank">PressLayouts</a> All Rights Reserved.', 'pressmart' ), esc_url( 'https://presslayouts.com' ) ),
						array(
							'a' => array(
								'href'   => array(),
								'target' => array(),
							),
						) 
				),
				'required'		=> array( 'footer-copyright', '=', 1 )
            ),
			array(
                'id'       => 'show-payments-logo',
                'type'     => 'switch',
                'title'    => esc_html__( 'Payments Logo', 'pressmart' ),
				'subtitle' => esc_html__( 'Show payment logo.', 'pressmart' ),
                'default'  => 0,
                'on'       => esc_html__( 'Yes', 'pressmart' ),
                'off'      => esc_html__( 'No', 'pressmart' ),
				'required'		=> array( 'footer-copyright', '=', 1 )
            ),
			array(
                'id'       => 'payments-logo',
                'type'     => 'media',
                'url'      => false,
                'title'    => esc_html__( 'Payments Logo Image', 'pressmart' ),
                'subtitle' => esc_html__( 'Upload payments logo image.', 'pressmart' ),
				'required' => array( 'show-payments-logo', '=', 1 )
            ),
			array(
				'id'             	=> 'footer-copyright-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Padding', 'pressmart' ),
				'subtitle'       	=> esc_html__( 'Set top bottom padding for footer copyright section.', 'pressmart' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'units'          	=> array('rem', '%', 'px'),
				'left'        	 	=> false,
                'right'        	 	=> false,
				'output' 			=> array( '.site-footer .footer-copyright' ),
				'default'            => array(
					'padding-top'     	=> '2', 
					'padding-bottom'  	=> '2',
					'units'          	=> 'rem', 
				)
			),
		)
	) );
	
	/*
	* Shop Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__('Shop','pressmart'),
        'id'         => 'section-shop',
		'icon'		 => 'el el-shopping-cart',
		'fields'     => array(
			array(
                'id'       		=> 'order-tracking-page',
                'type'     		=> 'select',
                'data'     		=> 'pages',
                'title'    		=> esc_html__( 'Order Tracking Page', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set your order tracking page.', 'pressmart' ),
                'desc' 			=> esc_html__( 'Page contents: [woocommerce_order_tracking]', 'pressmart' ),
            ),
			array(
                'id'       => 'product-search-by-sku',
                'type'     => 'switch',
                'title'    => esc_html__( 'Search By Product SKU', 'pressmart' ),
				'subtitle' => esc_html__( 'Ajax search product by  sku.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'manage-password-strength',
                'type'     => 'switch',
                'title'    => esc_html__( 'Manage Password Strength', 'pressmart' ),
				'subtitle' => esc_html__( 'Reduce the strength requirement on the woocommerce user login/signup password', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'user-password-strength',
                'type'     => 'button_set',
                'title'    => esc_html__( 'User Password Strength', 'pressmart' ),
                'options'  => array(
                    '3' => esc_html__( 'Strong (default)', 'pressmart' ),
                    '2' => esc_html__( 'Medium', 'pressmart' ),
					'1' => esc_html__( 'Weak', 'pressmart' ),
					'0' => esc_html__( 'Very Weak', 'pressmart' ),
                ),
                'default'  => '3',
				'required' => array( 'manage-password-strength', '=', 1 )
            ),
			array(
                'id'       		=> 'single-line-product-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Single Line Title', 'pressmart' ),
				'subtitle' 	   	=> esc_html__( 'Show product/category/widget  title in single line.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       => 'mini-cart-quantity',
                'type'     => 'switch',
                'title'    => esc_html__( 'Quantity Field in Mini Cart', 'pressmart' ),
				'subtitle'     => esc_html__( 'Show quantity field in mini cart. ', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
		),
	) );
	
	/*
	* Product labels		
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Product labels', 'pressmart' ),
        'id'         => 'section-product-labels',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'product-labels',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Labels', 'pressmart' ),
                'subtitle' => esc_html__( 'Show labels sale, featured, new and out of stock on product.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'sale-product-label',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sale Product Label', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'product-labels', '=', 1 )
            ),
			array(
                'id'      		=> 'sale-product-label-after-price',
                'type'     		=> 'button_set',
				'desc' 			=> esc_html__( 'Show sale product label after price or on product image in shop/listing page.', 'pressmart' ),
                'options'  		=> array(
                    'after-price' 		=> esc_html__( 'After Price', 'pressmart' ),
                    'on-product-image'	=> esc_html__( 'On Product Image', 'pressmart' ),
                ),
                'default'  		=> 'on-product-image',
				'required' 		=> array( 'sale-product-label', '=', 1 )
            ),
			array(
                'id'       => 'sale-product-label-text-options',
                'type'     => 'button_set',
				'desc' => esc_html__( 'sale product label in percentage or text.', 'pressmart' ),
                'options'  => array(
                    'percentages' => esc_html__( 'Percentages', 'pressmart' ),
                    'text' => esc_html__( 'Text', 'pressmart' ),
                ),
                'default'  => 'percentages',
				'required' => array( 'sale-product-label', '=', 1 )
            ),
			array(
                'id'       => 'sale-product-label-percentage-text',
                'type'     => 'text',
                'subtitle'    => esc_html__( 'Sale label percentage text.', 'pressmart' ),
				'default'  => esc_html__( 'Off', 'pressmart' ),
				'required' => array( 'sale-product-label-text-options', '=', 'percentages' )
            ),
			array(
                'id'       => 'sale-product-label-text',
                'type'     => 'text',
                'subtitle'    => esc_html__( 'Sale product label text.', 'pressmart' ),
				'default'  => esc_html__( 'Sale', 'pressmart' ),
				'required' => array( 'sale-product-label-text-options', '=', 'text' )
            ),
			array(
                'id'       => 'sale-product-label-color',
                'type'     => 'color',
                'subtitle'    => esc_html__( 'Sale product label color.', 'pressmart' ),
                'default'  => '#388E3C',
				'required' => array( 'sale-product-label', '=', 1 )
            ),
			array(
                'id'       => 'product-new-label',
                'type'     => 'switch',
                'title'    => esc_html__( 'New Product Label', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       => 'new-product-label-text',
                'type'     => 'text',
                'subtitle'    => esc_html__( 'New product label text.', 'pressmart' ),
				'default'  => esc_html__( 'New', 'pressmart' ),
				'required' => array( 'product-new-label', '=', 1 )
            ),
			array(
                'id'            => 'product-newness-days',
                'type'          => 'slider',
                'subtitle'          => esc_html__( 'Enter number of days to newness.', 'pressmart' ),
                'default'       => 30,
                'min'           => 1,
                'step'          => 1,
                'max'           => 90,
                'display_value' => 'text',
				'required' => array( 'product-new-label', '=', 1 )
            ),
			array(
                'id'       => 'new-product-label-color',
                'type'     => 'color',
                'subtitle'    => esc_html__( 'New product label color.', 'pressmart' ),
                'default'  => '#82B440',
				'required' => array( 'product-new-label', '=', 1 )
            ),
			array(
                'id'       => 'featured-product-label',
                'type'     => 'switch',
                'title'    => esc_html__( 'Featured Product Label', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       => 'featured-product-label-text',
                'type'     => 'text',
                'subtitle'    => esc_html__( 'Featured product label text.', 'pressmart' ),
				'default'  => esc_html__( 'Featured', 'pressmart' ),
				'required' => array( 'featured-product-label', '=', 1 )
            ),
			array(
                'id'       => 'featured-product-label-color',
                'type'     => 'color',
                'subtitle'     => esc_html__( 'Featured product label color.', 'pressmart' ),
                'default'  => '#ff9f00',
				'required' => array( 'featured-product-label', '=', 1 )
            ),
			array(
                'id'       => 'outofstock-product-label',
                'type'     => 'switch',
                'title'    => esc_html__( 'Out Of Stock Product Label', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'product-labels', '=', 1 )
            ),
			array(
                'id'       => 'outofstock-product-label-text',
                'type'     => 'text',
                'subtitle'     => esc_html__( 'out of stock product label text.', 'pressmart' ),
				'default'  => esc_html__( 'Out Of Stock', 'pressmart' ),
				'required' => array( 'outofstock-product-label', '=', 1 )
            ),
			array(
                'id'       => 'outofstock-product-label-color',
                'type'     => 'color',
                'subtitle'    => esc_html__( 'Out of stock product label color.', 'pressmart' ),
                'default'  => '#ff6161',
				'required' => array( 'outofstock-product-label', '=', 1 )
            ),		
		),
	) );
		
	/*
	* Free Shipping Bar		
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Free Shipping Bar', 'pressmart' ),
        'id'         => 'section-freeshipping',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'free-shipping-bar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Free Shipping Bar', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'You want to enable free shipping bar or not?', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
				'id'      		=> 'free-shipping-amount',
				'type'    		=> 'text',
				'title'   		=> esc_html__( 'Enter Required Amount', 'pressmart' ), 
				'subtitle'   	=> wp_kses( sprintf( __( 'You can set frees hipping method amount from Woocommerce => settings => shipping => shipping zones => manage shipping method.For more read <a href="%s" target="_blank"> WooCommerce documentation </a> guide.', 'pressmart' ), esc_url( 'https://docs.woocommerce.com/document/free-shipping/' ) ),
				array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),     
				'default' 		=> '',								  
			),
			array(
				'id'      		=> 'free-shipping-msg',
				'type'    		=> 'textarea',
				'subtitle'    	=> esc_html__( 'Enter free shipping message text. Use {missing_amount} - The remaing amount for free shipping.', 'pressmart' ),
				'title'  		=> esc_html__( 'Free Shipping Message', 'pressmart' ),               
				'default' 		=> 'Spend {missing_amount} to get <strong>free shipping</strong>',
			),
			array(
				'id'      		=> 'free-shipping-complete-msg',
				'type'    		=> 'textarea',
				'title'   		=> esc_html__( 'Free Shipping Success Message', 'pressmart' ), 
				'subtitle'    	=> esc_html__( 'Message show after reaching progress bar 100%.', 'pressmart' ),
				'default' 		=> esc_html__( 'Congratulation! You have got free shipping', 'pressmart' ),	  
			),
			array(
				'id'      		=> 'shipping-bar-bg-color',
				'type'    		=> 'color',
				'title'   		=> esc_html__( 'Shipping Bar Background Color', 'pressmart' ),               
				'default' 		=> '#efefef',								  
			),
			array(
				'id'      		=> 'shipping-bar-color',
				'type'    		=> 'color',
				'title'   		=> esc_html__( 'Shipping Bar Color', 'pressmart' ),               
				'default' 		=> '#059473',								  
			),
		),
	) );
	/*
	* Login to see prices
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Login To See Price', 'pressmart' ),
        'id'         => 'section-login-to-see-price',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'login-to-see-price',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Login To See Price', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Only logged in users can see the pricing.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 0,
            ),
		),
	) );
		
	/*
	* Cart Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Cart', 'pressmart' ),
        'id'         => 'section-cart-page',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'cart-auto-update',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Auto Update Cart ', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Auto update cart when change product quantity.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 1,
            ),
		)
	) );
	
	/*
	* Checkout Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Checkout', 'pressmart' ),
        'id'         => 'section-checkout-page',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'checkout-steps',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Checkout Steps', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show checkout steps on Cart, Checkout and Order complete pages.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'checkout-product-image',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Image', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product image on checkout page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'checkout-product-quantity',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Quantity Filed', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product quantity filed on checkout page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 0,
            ),
		)
	) );
	
	/*
	* Shop Pages Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Archive(Shop) Pages', 'pressmart' ),
        'id'         => 'section-shop-page',
		'icon'		 => 'el el-shopping-cart',
        'fields'     => array(
			array(
                'id'       		=> 'shop-page-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Select shop/archive page layout with sidebar postion.', 'pressmart' ),
                'options'  		=> array(
                    'full-width' 	=> array(
                        'alt' 	=> esc_html__( 'Full Width', 'pressmart' ),
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' 	=> array(
                        'alt' 	=> esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' 	=> esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'left-sidebar'
            ),
			array(
                'id'       		=> 'shop-page-sidebar-widget',
                'type'     		=> 'select',
                'title'    		=> esc_html__( 'Sidebar Widget Area', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Select sidebar for shop page.', 'pressmart' ),
                'data'     		=> 'sidebars',
                'default'  		=> 'shop-page',
                'required' 		=> array( 'shop-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       		=> 'shop-page-off-canvas-sidebar',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Off Canvas Sidebar', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Display off canvas sidebar.', 'pressmart' ),
                'default'  		=> 0,
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'required' 		=> array( 'shop-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) ),
            ),
			array(
                'id'       		=> 'off-canvas-button-text',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Off Canvas Button Text', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Enter off canvas button text.', 'pressmart' ),
                'default'  		=> esc_html__( 'Filters', 'pressmart' ),
                'required' 		=> array( 'shop-page-off-canvas-sidebar', '=', 1 )
            ),
			array(
                'id'       		=> 'shop-page-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Title', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show shop page title.', 'pressmart' ),
                'default'  		=> 1,
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
            ),
			array(
				'id'      		=> 'shop-page-top-content',
				'type'    		=> 'select',
				'title'   		=> esc_html__( 'Shop Page Top Content', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Select block that display on shop page top area. You can create new block from Blocks => Add New', 'pressmart' ),
				'options'    	=> pressmart_get_posts_by_post_type( 'block', esc_html__( 'Select Block', 'pressmart' ) ),
				'default' 		=> ' ',
			),
			array(
				'id'      		=> 'shop-page-bottom-content',
				'type'    		=> 'select',
				'title'   		=> esc_html__( 'Shop Page Bottom Content', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Select block that display on shop page bottom area. You can create new block from Blocks => Add New', 'pressmart' ),
				'options'    	=> pressmart_get_posts_by_post_type( 'block', esc_html__( 'Select Block', 'pressmart' ) ),
				'default' 		=> ' ',
			),
			array(
                'id'       		=> 'products-header',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Products Header', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show products header.', 'pressmart' ),
                'default'  		=> 1,
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
            ),
			array(
                'id'       		=> 'products-view-icon',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product View Mode Icon', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show Product view mode icon on product header', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'products-view',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product View Mode', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Select by default product view mode.', 'pressmart' ),
                'options'  		=> array(
                    'grid-view' => esc_html__( 'Grid', 'pressmart' ),
                    'list-view' => esc_html__( 'List', 'pressmart' ),
                ),
                'default'  		=> 'grid-view',
				'required' 		=> array( 'products-view-icon', '=', 1 )
            ),
			array(
                'id'            => 'products-per-page',
                'type'          => 'slider',
                'title'         => esc_html__( 'Products Per Page', 'pressmart' ),
                'subtitle'      => esc_html__( 'Show number of products per page.', 'pressmart' ),
                'min'           => 6,
                'step'          => 1,
                'max'           => 120,
                'display_value' => 'text',
                'default'       => 12,
            ),
			array(
                'id'       		=> 'products-per-page-dropdown',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Products Per Page Dropdown', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show products per page dropdown on products header', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'products-per-page-number',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Products Per Page Variations', 'pressmart' ),
				'subtitle'     	=> esc_html__( 'Add product variations by comma. Ex. 9,12,24,36,48', 'pressmart' ),
                'default'  		=> '6,9,12,24,36,48',
				'required' 		=> array( 'products-per-page-dropdown', '=', 1 )
            ),			
			array(
                'id'       		=> 'products-sorting',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Products Sorting', 'pressmart' ),
				'subtitle' 	   	=> esc_html__( 'Show products sorting on shop page and archive pages.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),	
			array(
                'id'       		=> 'ajax-filter',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Ajax Filter', 'pressmart' ),
				'subtitle' 	   	=> esc_html__( 'Enable ajax filter on shop and product archive pages.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'products-columns',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    2		=> esc_html__( '2', 'pressmart' ),
                    3	 	=> esc_html__( '3', 'pressmart' ),
					4	 	=> esc_html__( '4', 'pressmart' ),
					5	 	=> esc_html__( '5', 'pressmart' ),
					6	 	=> esc_html__( '6', 'pressmart' ),
                ),
                'default'  		=> 4,
            ),
			array(
                'id'       		=> 'products-columns-tablet',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Tablet', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                    3	 	=> esc_html__( '3', 'pressmart' ),
					4	 	=> esc_html__( '4', 'pressmart' ),
                ),
                'default'  		=> 3,
            ),
			array(
                'id'       		=> 'products-columns-mobile',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Per Row Mobile', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many products should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                ),
                'default'  		=> 2,
            ),
			array(
                'id'       		=> 'products-pagination-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Products Pagination', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Select product pagination type.', 'pressmart' ),
                'options'  		=> array(
					'default'	=> esc_html__( 'Default', 'pressmart' ),
					'infinity-scroll'		=> esc_html__( 'Infinity Scroll', 'pressmart' ),
					'load-more-button'		=> esc_html__( 'Load More', 'pressmart' ),
				),
                'default'  		=> 'default',
            ),
			array(
                'id'       		=> 'products-pagination-load-more-button-text',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Load More Button Text', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Enter load more button text.', 'pressmart' ),
                'default'  		=> 'Load More',
				'required' 		=> array( 'products-pagination-style', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
			array(
                'id'       		=> 'products-pagination-finished-message',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Finished Message', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Text to display when no additional products are available.', 'pressmart' ),
                'default'  		=> 'No More Products Available',
				'required' 		=> array( 'products-pagination-style', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
		)
	) );
	
	/*
	* Product Styles
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Product Styles', 'pressmart' ),
        'id'         => 'product-styles',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'product-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Product Style', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Choose product style.', 'pressmart' ),
				'full_width' 	=> true,
                'options'  		=> array(
                    'product-style-1' => array(
                        'alt' 	=> 'Product Style 1',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-style-1.png',
                    ),
					'product-style-2' => array(
                        'alt' 	=> 'Product Style 2',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-style-2.png',
                    ),
                    'product-style-3' => array(
                        'alt' 	=> 'Product Style 3',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-style-3.png',
                    ), 
					'product-style-4' => array(
                        'alt' 	=> 'Product Style 4',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-style-4.png',
                    ),
					'product-style-5' => array(
                        'alt' 	=> 'Product Style 5',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-style-5.png',
                    ),
                ),
                'default'  	=> 'product-style-1',
            ),
			array(
                'id'       		=> 'product-quantity-field',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Quantity Field', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Show quantity filed on home and shop page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-style', '=', 'product-style-5' )
            ),
			array(
                'id'       		=> 'product-hover-image',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Hover Image', 'pressmart' ),
				'subtitle'      => esc_html__( 'Show product hover image on products.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),		
			array(
                'id'       		=> 'product-countdown',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Countdown', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product countdown.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-category',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Category', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product category.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Title', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product title.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-rating',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Rating', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product rating.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-rating-count',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Rating Count', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product rating count.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-rating', '=', 1 )
            ),
			array(
                'id'       		=> 'product-price',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Price', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product price.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),			
			array(
                'id'       		=> 'product-variations',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Variation(Options)', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product variation(attribute) on product hover. Like Color, Size, ...', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),				
			array(
                'id'       		=> 'product-short-description',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Short Description', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show product short description in list view.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),		
		)
	) );
	
	/*
	* Product category Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Categories Page', 'pressmart' ),
        'id'         => 'product-categories-page',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'category-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Category Style', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Select category style', 'pressmart' ),
                'options'  		=> array(                    
                    'category-style-1' => array(
                        'alt' 	=> 'Category Style 1',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'layout/category-style-1.png',
                    ),
					'category-style-2' => array(
                        'alt' 	=> 'Category Style 2',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'layout/category-style-2.png',
                    ),
					'category-style-3' => array(
                        'alt' 	=> 'Category Style 3',
                        'img' 	=> PRESSMART_ADMIN_IMAGES . 'layout/category-style-3.png',
                    ),
                ),
                'default'  		=> 'category-style-1',
            ),
		)
	) );
	
	/*
	* Product Catalog Mode
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Catalog Mode', 'pressmart' ),
        'id'         => 'product-catalog-mode',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'catalog-mode',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Catalog Mode', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Enable catalog mode.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'open-product-page-new-tab',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Open Product In New Tab', 'pressmart' ),
				'subtitle'      => esc_html__( 'Open product page in new tab.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'product-buttons',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Buttons', 'pressmart' ),
                'subtitle'      => esc_html__( 'Show product buttons cart, wishlist, compare and quick view in shop page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
				'off'      		=> esc_html__( 'Hide', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'product-cart-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Cart Button', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Show cart button on shop page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
				'off'      		=> esc_html__( 'Hide', 'pressmart' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'product-wishlist-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Wishlist Button', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Show wishlist button on shop page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
				'off'      		=> esc_html__( 'Hide', 'pressmart' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'product-compare-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Compare Button', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Show compare button on shop page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
				'off'      		=> esc_html__( 'Hide', 'pressmart' ),
				'default'  		=> 1,
				'required'		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'product-quickview-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Quick View Button', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Show quick view button on shop page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
				'off'      		=> esc_html__( 'Hide', 'pressmart' ),
				'default'  		=> 1,
				'required' 		=> array( 'product-buttons', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-quick-buy',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Quick Buy Button', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Show quick buy button on product page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Show', 'pressmart' ),
				'off'      		=> esc_html__( 'Hide', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'type'      	=> 'text',
                'id'        	=> 'product-quickbuy-button-text',
                'title'     	=> esc_html__( 'Quick Buy Button Text', 'pressmart' ),
                'subtitle'  	=> esc_html__( 'Enter quick buy button text.', 'pressmart' ),
                'default'     	=> 'Buy Now',
                'required'  	=> array( 'single-product-quick-buy', '=', 1 ),
            ),
		)
	) );

	/*
	* Single Product Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Product', 'pressmart' ),
        'id'         => 'single-product-page',
		'icon'		 => 'el el-shopping-cart',
        'fields'     => array(
			array(
                'id'       		=> 'product-page-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Page Layout', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Select product page layout with sidebar postion.', 'pressmart' ),
				'options'  		=> array(
                    'full-width' => array(
                        'alt' => esc_html__( 'Full Width', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' => array(
                        'alt' => esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' => esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  		=> 'full-width'				
            ),
			array(
                'id'       		=> 'product-page-sidebar-widget',
                'type'     		=> 'select',
                'title'    		=> esc_html__( 'Sidebar Widget Area', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Select sidebar for product page.', 'pressmart' ),
                'data'     		=> 'sidebars',
                'default'  		=> 'single-product',
                'required' 		=> array( 'product-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       		=> 'sticky-product-image',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sticky Product Image', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'When you scroll the product page at this time you want to stick product image part or not.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'sticky-product-summary',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sticky Product Summary', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'When you scroll the product page at this time you want to stick product summary part or not.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'sticky-add-to-cart-button',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Sticky Add to Cart Button', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Sticky add to cart button on bottom when scroll the page.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 0,
            ),
		)
		));
		
		/*
		* Product Images/Gallery
		*/
		Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Images/Gallery', 'pressmart' ),
			'id'         => 'product-images-gallery',
			'subsection' => true,
			'fields'     => array(
				array(
					'id'       	=> 'product-gallery-style',
					'type'     	=> 'image_select',
					'title'    	=> esc_html__( 'Gallery Layout', 'pressmart' ),
					'options'  	=> array(
						'product-gallery-left' 	=> array(
							'title' 	=> esc_html__( 'Thumbnail Left', 'pressmart' ),
							'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-left.png',
						),                   
						'product-gallery-bottom' 	=> array(
							'title' 	=> esc_html__( 'Thumbnail Bottom', 'pressmart' ),
							'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-bottom.png',
						),
						'product-gallery-horizontal' 	=> array(
							'title' 	=> esc_html__( 'Gallery Horizontal', 'pressmart' ),
							'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-horizontal.png',
						),
						'product-gallery-center' 	=> array(
							'title' 	=> esc_html__( 'Gallery Center', 'pressmart' ),
							'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-center.png',
						),
						'product-gallery-grid' 	=> array(
							'title' 	=> esc_html__( 'Gallery Grid', 'pressmart' ),
							'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-grid.png',
						),
						'product-sticky-info' 	=> array(
							'title' 	=> esc_html__( 'Sticky Info', 'pressmart' ),
							'img' 	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-sticky-info.png',
						),
					),
					'default'  	=> 'product-gallery-left'
				),
				array(
					'id'       => 'product-gallery-zoom',
					'type'     => 'switch',
					'title'    => esc_html__( 'Product Gallery Zoom', 'pressmart' ),
					'on'       => esc_html__( 'Enable', 'pressmart' ),
					'off'      => esc_html__( 'Disable', 'pressmart' ),
					'default'  => 1,
				),
				array(
					'id'       => 'product-gallery-lightbox',
					'type'     => 'switch',
					'title'    => esc_html__( 'Product Gallery Lightbox', 'pressmart' ),
					'on'       => esc_html__( 'Enable', 'pressmart' ),
					'off'      => esc_html__( 'Disable', 'pressmart' ),
					'default'  => 1,
				),
				array(
					'id'       => 'product-video',
					'type'     => 'switch',
					'title'    => esc_html__( 'Product Video', 'pressmart' ),
					'subtitle' => esc_html__( ' You want to show product video?', 'pressmart' ),
					'on'       => esc_html__( 'Yes', 'pressmart' ),
					'off'      => esc_html__( 'No', 'pressmart' ),
					'default'  => 1,
				),
				array(
					'id'       => 'product-360-degree',
					'type'     => 'switch',
					'title'    => esc_html__( 'Product 360 degree Image', 'pressmart' ),
					'subtitle' => esc_html__( ' You want to show product video?', 'pressmart' ),
					'on'       => esc_html__( 'Yes', 'pressmart' ),
					'off'      => esc_html__( 'No', 'pressmart' ),
					'default'  => 1,
				),				
			),
		) );
		
		/*
		* Product Summary
		*/
		Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Summary', 'pressmart' ),
			'id'         => 'product-summary',
			'subsection' => true,
			'fields'     => array(
			array(
                'id'       		=> 'single-product-breadcrumbs',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Breadcrumbs', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product breadcrumbs. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-breadcrumbs-position',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Breadcrumbs Position', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select breadcrumbs position. ', 'pressmart' ),
                'options'  		=> array(
                    'above-summary' 	=> esc_html__( 'Above Summary', 'pressmart' ),
                    'above-image'		=> esc_html__( 'Above Image', 'pressmart' ),
                ),
                'default'  		=> 'above-summary',
				'required' 		=> array( 'single-product-breadcrumbs', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-navigation',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Navigation', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product navigation. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-rating',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Rating', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product rating. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-countdown',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Countdown', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product countdown. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-countdown-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Countdown Style', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Select countdown style. ', 'pressmart' ),
                'options'  		=> array(
					'countdown-box'		=> esc_html__( 'Box', 'pressmart' ),
					'countdown-text'  	=> esc_html__( 'Text', 'pressmart' ),					
				),
                'default'  		=> 'countdown-box',
				'required' 		=> array( 'single-product-countdown', '=', 1 )
            ),
			array(
                'id'        	=> 'single-product-countdown-tag',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'Countdown Tag', 'pressmart' ),
                'default' 		=> 'Special price ends in less than',
				'required' 		=> array( 'single-product-countdown-style', '=', 'countdown-text' )
            ),
			array(
                'id'      		=> 'sale-single-product-label-after-price',
                'type'     		=> 'button_set',
				'title'     	=> esc_html__( 'Sale Product Label', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Show sale product label after price or on product image in product page.', 'pressmart' ),
                'options'  		=> array(
                    'after-price' 		=> esc_html__( 'After Price', 'pressmart' ),
                    'on-product-image'	=> esc_html__( 'On Product Image', 'pressmart' ),
                ),
                'default'  		=> 'on-product-image',
            ),
			array(
                'id'       		=> 'single-product-availability',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Availability', 'pressmart' ),
				'subtitle'     	=> esc_html__( 'Show Product availability message like In Stock, Out Of Stock, Hurry left, etc...', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'        	=> 'single-product-availability-instock-msg',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'In Stock Message', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Use {qty} for show number of quantity.', 'pressmart' ),
                'default' 		=> 'In Stock',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'            => 'single-product-availability-lowstock-qty',
                'type'          => 'slider',
                'title'         => esc_html__( 'Low Stock Qty', 'pressmart' ),
                'subtitle'		=> esc_html__( 'How many numbers you want to display below low stock messages. like Hurry, Only {qty} left.', 'pressmart' ),
                'default'       => 5,
                'min'           => 1,
                'step'          => 1,
                'max'           => 25,
                'display_value' => 'text',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'        	=> 'single-product-availability-hurry-left-msg',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'Stock Hurry Left Message', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Default template is: Hurry, Only {qty} left.Here {qty} is number of item available in stock', 'pressmart' ),
                'default' 		=> 'Hurry, Only {qty} left.',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'        	=> 'single-product-availability-outstock-msg',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'Out of Stock Message', 'pressmart' ),
                'default' 		=> 'Out of Stock',
				'required' 		=> array( 'single-product-availability', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-brands',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Brands', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product brand. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-short-description',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Short Description(Highlight)', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product short description/highlight. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'        	=> 'single-product-short-description-label',
                'type'      	=> 'text',
                'title'     	=> esc_html__( 'Short Description(Highlight) Label', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product short description/highlight label text. ', 'pressmart' ),
                'default' 		=> 'Highlights:',
				'required' 		=> array( 'single-product-short-description', '=', 1 )
            ),
			array(
                'id'       		=> 'product-add-to-cart-ajax',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Add to Cart Using Ajax', 'pressmart' ),
				'subtitle'    	 => esc_html__( 'Add to cart product using ajax without load page. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-size-chart',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Size Guide', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show size guide. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'single-product-meta',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Meta', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product meta like SKU, category, tag, etc...', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),		
			array(
                'id'       		=> 'single-product-share',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Share', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Show product share. ', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
		)
	) );
	
	/*
	* Product Bought Together
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Bought Together', 'pressmart' ),
        'id'         => 'product-bought-together',
		'subsection' => true,
        'fields'     => array(
			
			array(
                'id'       		=> 'single-product-bought-together',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Bought Together', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'type'     		=> 'text',
                'id'			=> 'product-bought-together-title',
                'title'			=> esc_html__( 'Bought Together Title', 'pressmart' ),
				'default'  		=> 'Frequently Bought Together',
                'required' 		=> array( 'single-product-bought-together', '=', 1 )
            ),
			array(
                'id'       		=> 'product-bought-together-location',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Bought Together Location', 'pressmart' ),
                'options'  		=> array(
					'summary-bottom'  	=> esc_html__( 'Summary Bottom', 'pressmart' ),
					'after-summary'		=> esc_html__( 'After Summary', 'pressmart' ),					
					'in-tab'  			=> esc_html__( 'In Tab', 'pressmart' ),
				),
                'default'  		=> 'summary-bottom',
				'required' 		=> array( 'single-product-bought-together', '=', 1 )
            ),			
		),
	) );
	
	/*
	* Product Tags
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Tabs', 'pressmart' ),
        'id'         => 'product-tabs',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'single-product-tabs',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Tabs', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'single-product-tabs-style',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product Tabs Style', 'pressmart' ),
                'options'  		=> array(
					'tabs'  		=> esc_html__( 'Tabs', 'pressmart' ),
					'accordion'		=> esc_html__( 'Accordion', 'pressmart' ),					
					'toggle'  		=> esc_html__( 'Toggle', 'pressmart' ),
				),
                'default'  		=> 'tabs',
				'required' 		=> array( 'single-product-tabs', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-tabs-location',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Product Tabs Location', 'pressmart' ),
                'options'  		=> array(
					'after-summary'		=> esc_html__( 'After Summary', 'pressmart' ),	
					'summary-bottom'  	=> esc_html__( 'Summary Bottom', 'pressmart' ),
				),
                'default'  		=> 'after-summary',
				'required' 		=> array( 'single-product-tabs', '=', 1 )
            ),
			array(
                'id'       		=> 'single-product-tabs-titles',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Product Tabs Titles', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
				'required' 		=> array( 'single-product-tabs', '=', 1 )
            ),
		),
	) );
	
	/*
	* Product Related/Up-Sells/Recently-Viewed
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Related/Up-Sells/Rviewed', 'pressmart' ),
        'id'         => 'product-related-upsells-rv',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       		=> 'upsells-products',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Up Sells Products', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'related-products',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Related Products', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'recently-viewed-products',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Recently Viewed Products', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'            	=> 'related-upsells-products',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Show Number Of Products', 'pressmart' ),
				'subtitle'     		=> esc_html__( 'How many products you want to display?', 'pressmart' ),
                'default'       	=> 12,
                'min'           	=> 1,
                'step'          	=> 1,
                'max'           	=> 24,
                'display_value' 	=> 'text',
            ),
			array(
                'id'       			=> 'related-upsell-auto-play',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Carousel Autoplay', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'related-upsells-loop',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Carousel Inifnity Loop', 'pressmart' ),
                'subtitle' 			=> esc_html__( 'Enables related/up sells products carousel Inifnity loop. Duplicate last and first products to get loop illusion.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'related-upsell-navigation',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Carousel Navigation', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),
			array(
                'id'       			=> 'related-upsell-product-dots',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Carousel Dots Navigation', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 1,
            ),			
			array(
                'id'       			=> 'related-upsell-products-columns',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Products Per Row', 'pressmart' ),
				'subtitle'      	=> esc_html__( 'How many products should be shown per row?', 'pressmart' ),
                'options'  			=> array(
                    2		=> esc_html__( '2', 'pressmart' ),
                    3	 	=> esc_html__( '3', 'pressmart' ),
					4	 	=> esc_html__( '4', 'pressmart' ),
					5	 	=> esc_html__( '5', 'pressmart' ),
					6	 	=> esc_html__( '6', 'pressmart' ),
                ),
                'default'  			=> 5,
            ),
			array(
                'id'       			=> 'related-upsell-products-columns-tablet',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Products Per Row Tablet', 'pressmart' ),
				'subtitle'      	=> esc_html__( 'How many products should be shown per row?', 'pressmart' ),
                'options'  			=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                    3	 	=> esc_html__( '3', 'pressmart' ),
					4	 	=> esc_html__( '4', 'pressmart' ),
                ),
                'default'  			=> 3,
            ),
			array(
                'id'       			=> 'related-upsell-products-columns-mobile',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Products Per Row Mobile', 'pressmart' ),
				'subtitle'      	=> esc_html__( 'How many products should be shown per row?', 'pressmart' ),
                'options'  			=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                ),
                'default'  			=> 2,
            ),
		),
	) );
	
	/**
	* Advance Options
	*/ 
    Redux::setSection( $opt_name, array(
        'title'   		=> esc_html__( 'Advance Options ', 'pressmart' ),
		'id'         	=> 'section-advance-options',
		'subsection' 	=> true,
        'fields'  		=> array(
			array(
                'id'    			=> 'delivery-return-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Delivery & Return', 'pressmart' ),
            ),
			array(
                'id'       			=> 'product-delivery-return',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Delivery & Return', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Show delivery & return terms on product page.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'delivery-return-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Delivery & Return Label', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter your own delivery & return label.', 'pressmart' ),
				'default'  			=> 'Delivery & Return',
				'required'			=> array( 'product-delivery-return', '=', 1 )
            ),
			array(
				'id'       			=> 'delivery-return-terms',
				'type'     			=> 'select',
				'data' 	   			=> 'posts',
				'args' 				=> array( 'post_type'=>'block','posts_per_page' => -1 ),
				'title'    			=> esc_html__('Select Terms Block', 'pressmart' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'Choose delivery & retund terms block. You can add custom block from <a href="%s" target="_blank">here</a>', 'pressmart' ), esc_url( admin_url( 'post-new.php?post_type=block' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'placeholder' 		=> esc_attr__( 'Choose terms block', 'pressmart' ),
				'required'			=> array( 'product-delivery-return', '=', 1 )
			),
			array(
                'id'    			=> 'ask-quetion-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Ask a Question', 'pressmart' ),
            ),
			array(
                'id'       			=> 'product-ask-quetion',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Ask a Question', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Show ask a question form on product page.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'ask-quetion-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Ask a Question Label', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter ask a question label text.', 'pressmart' ),
				'default'  			=> 'Ask a Question',
				'required'			=> array( 'product-ask-quetion', '=', 1 )
            ),
			array(
                'id'       			=> 'ask-quetion-form-title',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Ask a Question Form Title', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter ask a question form(popup) title.', 'pressmart' ),
				'default'  			=> 'Ask a Question',
				'required'			=> array( 'product-ask-quetion', '=', 1 )
            ),
			array(
				'id'       			=> 'ask-question-form',
				'type'     			=> 'select',
				'data' 	   			=> 'posts',
				'args' 				=> array( 'post_type'=>'wpcf7_contact_form','posts_per_page' => -1 ),
				'title'    			=> esc_html__('Select Ask Question Form', 'pressmart' ),
				'subtitle'   		=> wp_kses( sprintf( __( 'Choose ask a question form. You can add custom form  from <a href="%s" target="_blank">here</a>', 'pressmart' ), esc_url( admin_url( 'admin.php?page=wpcf7-new' ) ) ), array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
				'placeholder' 		=> esc_attr__( 'Choose form block', 'pressmart' ),
				'required'			=> array( 'product-ask-quetion', '=', 1 )
			),
			array(
                'id'    			=> 'estimated-delivery-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Estimated Delivery Time', 'pressmart' ),
            ),
			array(
                'id'       			=> 'product-estimated-delivery',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Estimated Delivery', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Show estimated delivery on product page.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),			
			array(
                'id'       			=> 'estimated-delivery-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Estimated Delivery Label', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter your own estimated delivery label.', 'pressmart' ),
				'default'  			=> 'Estimated Delivery:',
				'required'			=> array( 'product-estimated-delivery', '=', 1 )
            ),
			array(
				'id' 				=> 'estimated-delivery-days',
				'type' 				=> 'slider',
				'title' 			=> esc_html__( 'Set Estimated Days', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Set estimated delivery days. Ex. 3-7 days', 'pressmart' ),
				"min" 				=> 1,
				"step" 				=> 1,
				"max" 				=> 30,
				'display_value' 	=> 'text',
				'handles' 			=> 2,
				"default" 			=> array(
					1 		=> 3,
					2 		=> 7,
				),
				'required' 			=> array( 'product-estimated-delivery', '=', 1 ),
			),
			array(
                'id'    			=> 'product-visitor-count-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Visitor Count', 'pressmart' ),
            ),
			array(
                'id'       			=> 'single-product-visitor-count',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Visitor Count', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Show the number of fake visitors currently viewing a product on product page.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
				'id' 				=> 'random-visitor-number',
				'type' 				=> 'slider',
				'title' 			=> esc_html__( 'Set Random Number', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Set min and max range to get random number between these value.', 'pressmart' ),
				"min" 				=> 1,
				"step" 				=> 1,
				"max" 				=> 200,
				'display_value' 	=> 'text',
				'handles' 			=> 2,
				"default" 			=> array(
					1 		=> 20,
					2 		=> 50,
				),
				'required' 			=> array( 'single-product-visitor-count', '=', 1 ),
			),
			array(
                'id'       			=> 'visitor-count-text',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Enter Visitor Text', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter visitor text. Use {visitor_count} for display visitor count number.', 'pressmart' ),
				'default'  			=> '{visitor_count} People viewing this product right now!',
				'required' 			=> array( 'single-product-visitor-count', '=', 1 ),
            ),
			array(
				'id'       			=> 'visitor-count-delay-time',
				'type'     			=> 'slider', 
				'title'    			=> esc_html__( 'Update Visitors Count Number', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Select seconds to delay update the number of visitors count.', 'pressmart' ),
				'default'  			=> 5,
				'min'      			=> 1,
				'step'     			=> 1,
				'max'      			=> 60,
				'display_value' 	=> 'text',
				'required' 			=> array( 'single-product-visitor-count', '=', 1 ),
			),
			array(
                'id'    			=> 'product-policy-notice',
                'type'   			=> 'info',
                'notice' 			=> false,
                'title' 			=> esc_html__( 'Product Policy', 'pressmart' ),
            ),
			array(
                'id'       			=> 'single-product-policies',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Product Policy', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Show product policy on single product page.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
				'id'				=> 'product-policies',
				'type'				=> 'repeater',
				'title'				=> esc_html__( 'Product Policy List', 'pressmart' ),
				'bind_title'		=> 'policy_title',
				'group_values'		=> true,
				'fields'     		=> array(
					array(
						'id'          	=> 'policy_title',
						'title'   		=> esc_html__( 'Enter Title', 'pressmart' ),
						'type'        	=> 'text',
						'placeholder' 	=> esc_html__( 'Tile', 'pressmart' ),
					),
					array(
						'id'			=> 'policy_icon_class',
						'title'   		=> esc_html__( 'Enter Font Class', 'pressmart' ),
						'type'			=> 'text',
						'placeholder'	=> esc_html__( 'Font icon class', 'pressmart' ),
					),               
					array(
						'id'      		=> 'policy_block',
						'type'    		=> 'select',
						'title'   		=> esc_html__( 'Select Block', 'pressmart' ),
						'options' 		=> pressmart_get_posts_by_post_type( 'block', esc_html__( 'Select Block', 'pressmart' ) ),
						'placeholder' 	=> esc_html__( 'Select Block', 'pressmart' ),
					),
				),
				'default'			=> array(
					'redux_repeater_data' 	=> array(
						array(
							'title' => '',
						),
						array(
							'title' => '',
						),
						array(
							'title' => '',
						),
						array(
							'title' => '',
						)
					),
					'policy_title'      	=> array(
						'Free Shipping',
						'1 Year Warranty',
						'Secure payment',
						'30 Days Return',
					),
					'policy_icon_class'   	=> array(
						'picon-truck',
						'picon-shield-check',
						'picon-handshake',
						'picon-reload',
					),				
					'policy_block'          => array(
						'',
						'',
						'',
						'',
					),
				),
				'required' 			=> array( 'single-product-policies', '=', 1 ),
			),
			array(
                'id'    		=> 'product-trust-badge-notice',
                'type'   		=> 'info',
                'notice' 		=> false,
                'title' 		=> esc_html__( 'Trust Badge Image', 'pressmart' ),
            ),
			array(
                'id'       			=> 'single-product-trust-badge',
                'type'     			=> 'switch',
                'title'    			=> esc_html__( 'Trust Badge', 'pressmart' ),
				'subtitle'			=> esc_html__( 'Show trust badge image on single product page.', 'pressmart' ),
                'on'       			=> esc_html__( 'Yes', 'pressmart' ),
				'off'      			=> esc_html__( 'No', 'pressmart' ),
				'default'  			=> 0,
            ),
			array(
                'id'       			=> 'trust-badge-label',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Trust Badge Label', 'pressmart' ),
				'subtitle' 			=> esc_html__( 'Enter your own trust badge label.', 'pressmart' ),
				'default'  			=> 'Guaranteed Safe Checkout',
				'required'			=> array( 'single-product-trust-badge', '=', 1 )
            ),
			array(
                'id'       		=> 'trust-badge-image',
                'type'     		=> 'media',
                'url'      		=> true,
                'title'    		=> esc_html__( 'Trust Badge Image', 'pressmart' ),
                'compiler' 		=> 'true',
                'subtitle' 		=>  esc_html__( 'Upload trust badge image.', 'pressmart' ),
                'default'  		=> array(),
				'required' 		=> array( 'single-product-trust-badge', '=', 1 ),
            ),
		)
    ));
	
	/**
	* Login/Register 
	*/ 
    Redux::setSection( $opt_name, array(
        'title'   		=> esc_html__( 'Login/Register', 'pressmart' ),
		'id'         	=> 'section-login-register',
		'icon'		 	=> 'el el-user',
        'fields'  		=> array(
			array(
				'id'       		=> 'login-information',
				'type'     		=> 'editor',
				'title'    		=> esc_html__( 'Login Information', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Display login information in login form.', 'pressmart' ),
				'args'   		=> array(
					'teeny'   => true,
				),
				'default'  		=> esc_html__( 'Get access to your Orders, Wishlist and Recommendations.', 'pressmart' ),
			)
		)
    ));
	
	if ( function_exists( 'pressmart_vendor_theme_options' ) && ( class_exists( 'WeDevs_Dokan' ) || class_exists( 'WC_Vendors' ) || class_exists( 'WCMp' ) || class_exists( 'WCFMmp' ) ) ) {
		/*
		* Vendor Options
		*/
		$vendor_options = pressmart_vendor_theme_options();
		Redux::setSection( $opt_name, array(
			'title'      => esc_html__( 'Vendor Options', 'pressmart' ),
			'id'         => 'vendor-options',
			'icon'		 => 'el-icon-broom',
			'fields'     => $vendor_options,
		) );
	}
	
	/*
	* Page Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page', 'pressmart' ),
        'id'         => 'page',
		'icon'		 => 'el el-list-alt',
        'fields'     => array(
			array(
                'id'       => 'page-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Page Layout', 'pressmart' ),
                'subtitle' => esc_html__( 'Select page layout with sidebar postion.', 'pressmart' ),
				'options'  => array(
                    'full-width' => array(
                        'alt' => esc_html__( 'Full Width', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' => array(
                        'alt' => esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' => esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  => 'full-width'
            ),
			array(
                'id'       => 'page-sidebar-widget',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar Widget Area', 'pressmart' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       => 'page-comments',
                'type'     => 'switch',
                'title'    => esc_html__( 'Page Comment', 'pressmart' ),
                'subtitle' => esc_html__( 'Show comments and comment form on page.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
		)
	) );
	
	/*
	* Page Widget Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Sidebar Widget', 'pressmart' ),
        'id'         => 'page-widget',
        'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'sticky-sidebar',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sidebar Sticky', 'pressmart' ),
                'subtitle' => esc_html__( 'When you scroll the page at this time you want to sticky sidebar part in all pages or not.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'widget-toggle',
                'type'     => 'switch',
                'title'    => esc_html__( 'Widget Toggle', 'pressmart' ),
                'subtitle'     => esc_html__( 'Enable page widget toggle or not.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'widget-menu-toggle',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Widget Menu Toggle', 'pressmart' ),
                'subtitle'     => esc_html__( 'Enable page widget menu toggle or not.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'widget-items-hide-max-limit',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Widget Items Hide', 'pressmart' ),
                'subtitle'     => esc_html__( 'Enable widget items hide max limit.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'            => 'number-of-show-widget-items',
                'type'          => 'slider',
                'title'         => esc_html__( 'Show Number Of Widget Items', 'pressmart' ),
                'default'       => 8,
                'min'           => 5,
                'step'          => 1,
                'max'           => 50,
                'display_value' => 'text',
				'required' => array( 'widget-items-hide-max-limit', '=', 1 )
            ),
			array(
                'id'       => 'sidebar-canvas-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sidebar Canvas In Mobile', 'pressmart' ),
                'subtitle' => esc_html__( 'Display sidebar canvas in mobile.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
		)
	) );
	
	/*
	* 404 Page
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( '404 Page', 'pressmart' ),
        'id'         => '404-page',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       => '404-use-image-text',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Use Text Or Image', 'pressmart' ),
                'desc' => esc_html__( 'What a show on 404 page? Text or Image.', 'pressmart' ),
                'options'  => array(
                    '404-text'     => 'Text',
                    '404-image' => 'Image',
                ),
                'default'  => '404-text'
            ),
			array(
                'id'       => '404-page-title',
                'type'     => 'textarea',
                'title'    => esc_html__( '404 Page Title', 'pressmart' ),
				'default'  => 'Oops! That page can&rsquo;t be found.',
				'required' => array( '404-use-image-text', '=', '404-text' )
            ),
			array(
                'id'       => 'show-previous-link',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Previous Page Link', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( '404-use-image-text', '=', '404-text' )
            ),
			array(
                'id'       => '404-page-tagline',
                'type'     => 'textarea',
                'title'    => esc_html__( '404 Page Tag Line', 'pressmart' ),
				'default'  => 'Try using the button below to go to back previous page.',
				'required' => array( 'show-previous-link', '=', 1 )
            ),
			array(
                'id'       => 'previous-link-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Previous Page Link Title', 'pressmart' ),
				'default'  => 'Go to Back',
				'required' => array( 'show-previous-link', '=', 1 )
            ),
			array(
                'id'       => '404-page-image',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( '404 Page Image', 'pressmart' ),
                'compiler' => 'true',
                'desc' =>  esc_html__( 'Upload 404 page image and show on 404 page.', 'pressmart' ),
                'default'  => array(),
				'required' => array( '404-use-image-text', '=', '404-image' )
            ),
		)
	) );

	/*
	* Post options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog / Post', 'pressmart' ),
        'id'         => 'blog',
		'icon'		 => 'el el-edit',
        'fields'     => array(
			
			array(
                'id'       => 'post-date',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Date', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show post date', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'post-category',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Categories', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show post categories', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'sticky-post-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sticky Post Icon', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show sticky post icon', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'post-format-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Format Icon', 'pressmart' ),
                'subtitle'    => esc_html__( 'show post format icon', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'post-meta',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Meta', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show post meta', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'specific-post-meta',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Specific Post Meta', 'pressmart' ),
                'subtitle' => esc_html__( 'Select specific post meta to dispaly on post.', 'pressmart' ),
                'multi'    => true,
                'options'  => array(
					'post-author' 		=> esc_html__( 'Author', 'pressmart' ),
                    'post-date' 		=> esc_html__( 'Date', 'pressmart' ),
                    'post-category' 	=> esc_html__( 'Category', 'pressmart' ),					
                    'post-tags' 		=> esc_html__( 'Tags', 'pressmart' ),
					'post-comments' 	=> esc_html__( 'Comments', 'pressmart' ),
					'post-views' 		=> esc_html__( 'Views', 'pressmart' ),
					'post-rtime' 		=> esc_html__( 'Read Time', 'pressmart' ),
					'post-share' 		=> esc_html__( 'Share', 'pressmart' ),
					'post-edit' 		=> esc_html__( 'Edit', 'pressmart' ),
				),
                'default'  => array( 'post-author', 'post-date', 'post-comments' ),
				'required' => array( 'post-meta', '=', 1 )
            ),
			array(
                'id'       => 'post-meta-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Meta Icon', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show post meta icon', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
                'off'      => esc_html__( 'No', 'pressmart' ),
                'default'  => 1,
				'required' => array( 'post-meta', '=', 1 )
            ),
			array(
                'id'       => 'post-meta-separator',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Meta Separator', 'pressmart' ),
                'subtitle'    => esc_html__( 'Select post meta separator', 'pressmart' ),
                'options'  => array(
					'meta-separator-slash'	=> esc_html( '/' ),
					'meta-separator-colon'	=> esc_html( ':' ),
					'meta-separator-dot'	=> esc_html( '.' ),
					'meta-separator-bar'	=> esc_html( '|' ),
					'meta-separator-hyphen'	=> esc_html( '-' ),
					'meta-separator-tilde'	=> esc_html( '~' ),
				),
                'default'  => 'meta-separator-colon',
				'required' => array( 'post-meta', '=', 1 )
            ),
		)
	) );
	
	/*
	* Blog/Archives options
	*/
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog/Archive Page', 'pressmart' ),
        'id'         => 'blog-archive',
		'subsection'	 => true,
        'fields'     => array(
			array(
                'id'       => 'blog-page-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Page Layout', 'pressmart' ),
                'subtitle' => esc_html__( 'Select blog/archive page layout with sidebar postion.', 'pressmart' ),
				'options'  => array(
                    'full-width' => array(
                        'alt' => esc_html__( 'Full Width', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' => array(
                        'alt' => esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' => esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  => 'right-sidebar'
            ),
			array(
                'id'       => 'blog-page-sidebar-widget',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar Widget Area', 'pressmart' ),
                'subtitle'    => esc_html__( 'Choose sidebar widget area', 'pressmart' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'blog-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       		=> 'blog-page-title',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Title', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Show blog page title.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'          	=> 'blog-page-title-text',
                'type'        	=> 'text',
                'title'       	=> esc_html__( 'Page Title Text', 'pressmart' ),
                'subtitle' 	  	=> esc_html__( 'Enter blog page title.', 'pressmart' ),
                'default'       => esc_html__( 'Blog', 'pressmart' ),
                'placeholder' 	=> esc_attr__( 'Enter blog post title here', 'pressmart' ),
				'required' 		=> array( 'blog-page-title', '=', 1 )
            ),
			array(
                'id'       		=> 'blog-page-breadcrumb',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Page Breadcrumb', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Show blog page breadcrumb.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
                'id'       		=> 'blog-post-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Post Style', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Select post style', 'pressmart' ),
                'options'  		=> array(
					'blog-classic' => array(
                        'title' 	=> esc_html__( 'Blog Classic', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Blog Classic', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/blog-classic.png',
                    ),
					'blog-listing' => array(
                        'title' 	=> esc_html__( 'Blog Listing', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Blog Listing', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/blog-listing.png',
                    ),
					'blog-chess' => array(
                        'title' 	=> esc_html__( 'Blog Chess', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Blog Chess', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/blog-chess.png',
                    ),
					'blog-grid' => array(
                        'title' 	=> esc_html__( 'Blog Grid', 'pressmart' ),
                        'alt' 		=> esc_html__( 'Blog Grid', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/blog-grid.png',
                    ),
                ),
                'default'  	=> 'blog-classic',
            ),
			array(
                'id'       => 'blog-grid-layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Gird Layout', 'pressmart' ),
                'subtitle'    => esc_html__( 'Select blog gird layout', 'pressmart' ),
                'options'  => array(
                    'simple-grid' 		=> esc_html__( 'Simple', 'pressmart' ),
                    'masonry-grid' 		=> esc_html__( 'Masonry', 'pressmart' ),
                ),
                'default'  => 'simple-grid',
				'required' => array( 'blog-post-style', '=', 'blog-grid' )
            ),
			array(
                'id'       		=> 'blog-grid-columns',
                'type'    		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'If you have choosed post style grid or masonry grid layout, so you can manage here number of grid columns display.', 'pressmart' ),
                'options'  		=> array(
                    2 			=> esc_html__( '2', 'pressmart' ),
                    3 			=> esc_html__( '3', 'pressmart' ),
					4 			=> esc_html__( '4', 'pressmart' ),
                ),
                'default'  		=> 2,
				'required' 		=> array( 'blog-post-style', '=', 'blog-grid' )
            ),			
			array(
                'id'       		=> 'blog-grid-columns-tablet',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns Tablet', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many post should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                    3	 	=> esc_html__( '3', 'pressmart' ),
                ),
                'default'  		=> 2,
				'required' => array( 'blog-post-style', '=', 'blog-grid' )
            ),
			array(
                'id'       		=> 'blog-grid-columns-mobile',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns Mobile', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many post should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                ),
                'default'  		=> 1,
				'required' => array( 'blog-post-style', '=', 'blog-grid' )
            ),			
			array(
                'id'       => 'blog-post-thumbnail',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Thumbnail', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show post thumbnail', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'blog-post-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Title', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show post title', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
                'off'      => esc_html__( 'No', 'pressmart' ),
                'default'  => 1,
            ),
			array(
                'id'       => 'show-blog-post-content',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Content', 'pressmart' ),
                'subtitle' => esc_html__( 'Show blog post content.', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Yes', 'pressmart' ),
                'off'      => esc_html__( 'No', 'pressmart' ),
            ),
			array(
                'id'       		=> 'blog-post-content',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Post Content', 'pressmart' ),
                'subtitle'    	=> esc_html__( 'Select post content', 'pressmart' ),
                'options'  		=> array(
					'excerpt-content' 	=> esc_html__( 'Excerpt Content', 'pressmart' ),
					'full-content' 		=> esc_html__( 'Full Content', 'pressmart' ),
				),
                'default'  		=> 'full-content',
				'required' 		=> array( 'show-blog-post-content', '=', 1 )
            ),
			array(
                'id'            => 'blog-excerpt-length',
                'type'          => 'slider',
                'title'         => esc_html__( 'Excerpt Length (words)', 'pressmart' ),
                'subtitle'      => esc_html__( 'Show blog listing excerpt content length (words).', 'pressmart' ),
                'default'       => 30,
                'min'           => 10,
                'step'          => 1,
                'max'           => 100,
                'display_value' => 'text',
				'required' => array( 'blog-post-content', '=', 'excerpt-content' )
            ),
			array(
                'id'       => 'read-more-button',
                'type'     => 'switch',
                'title'    => esc_html__( 'Read More Button', 'pressmart' ),
                'subtitle'    => esc_html__( 'Show read more button', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),			
			array(
                'id'       => 'read-more-button-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Read More Button Style', 'pressmart' ),
                'subtitle'    => esc_html__( 'Select read more button style', 'pressmart' ),
                'options'  => array(
					'read-more-link' => esc_html__( 'Link', 'pressmart' ),
					'read-more-button' => esc_html__( 'Button', 'pressmart' ),
					'read-more-button-fill' => esc_html__( 'Button Fill', 'pressmart' ),
				),
                'default'  => 'read-more-link',
				'required' => array( 'read-more-button', '=', 1 )
            ),
			array(
                'id'       => 'post-readmore-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Read More Button Text', 'pressmart' ),
                'subtitle'    => esc_html__( 'Enter read more button text', 'pressmart' ),
				'default'  => 'Read More',
				'required' => array( 'read-more-button', '=', 1 )
            ),
			array(
                'id'       => 'blogs-pagination-type',
                'type'     => 'button_set',
                'title'    => esc_html__( ' Pagination Style', 'pressmart' ),
                'subtitle'    => esc_html__( ' Select pagination style', 'pressmart' ),
                'options'  => array(
					'default' 				=> esc_html__( 'Default', 'pressmart' ),
					'infinity-scroll'		=> esc_html__( 'Infinity Scroll', 'pressmart' ),
					'load-more-button' 		=> esc_html__( 'Load More', 'pressmart' ),
				),
                'default'  => 'default',
            ),
			array(
                'id'       => 'blog-pagination-load-more-button-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Load More Button Text', 'pressmart' ),
				'subtitle' => esc_html__( 'Enter load more button text.', 'pressmart' ),
                'default'  => 'Load More Posts',
				'required' => array( 'blogs-pagination-type', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
			array(
                'id'       => 'blog-pagination-finished-message',
                'type'     => 'text',
                'title'    => esc_html__( 'Finished Message', 'pressmart' ),
				'subtitle' => esc_html__( 'Text to display when no additional items are available.', 'pressmart' ),
                'default'  => 'No More Posts Available',
				'required' => array( 'blogs-pagination-type', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),			
		)
	) );
	
	/*
	* Single Post options
	*/
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Post', 'pressmart' ),
        'id'         => 'single-post',
		'subsection'	 => true,
        'fields'     => array(
			array(
                'id'       => 'single-post-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Page Layout', 'pressmart' ),
                'subtitle' => esc_html__( 'Select single post page layout with sidebar postion.', 'pressmart' ),
				'options'  => array(
                    'full-width' => array(
                        'alt' => esc_html__( 'Full Width', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' => array(
                        'alt' => esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' => esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  => 'right-sidebar'
            ),
			array(
                'id'       => 'single-post-sidebar-widget',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar Widget Area', 'pressmart' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'single-post-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       => 'single-post-thumbnail',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Thumbnail', 'pressmart' ),
                'subtitle' => esc_html__( 'Show post thumbnail or not.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-post-gallery-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Gallery Style', 'pressmart' ),
                'options'  => array(
					'slider'		=>esc_html__( 'Slider', 'pressmart' ),
					'grid'			=>esc_html__( 'Grid', 'pressmart' ),
					'one-column'	=>esc_html__( 'One Column', 'pressmart' ),					
				),
                'default'  => 'slider',
				'required' => array( 'single-post-thumbnail', '=', 1 )
            ),
			array(
                'id'       => 'single-post-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Title', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'         	=> 'single-post-title-text',
                'type'        	=> 'text',
                'title'       	=> esc_html__( 'Page Title Text', 'pressmart' ),
                'default'       => esc_html__( 'Our Blog', 'pressmart' ),
                'placeholder' 	=> esc_attr__( 'Enter post title here', 'pressmart' ),
				'required' 		=> array( 'single-post-title', '=', 1 )
            ),
			array(
                'id'       => 'single-post-author-info',
                'type'     => 'switch',
                'title'    => esc_html__( 'Author Info', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'       => 'single-post-tag',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Tags', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'       => 'single-post-social-share-link',
                'type'     => 'switch',
                'title'    => esc_html__( 'Social Share Links', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'       => 'single-post-navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Navigation', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-post-comment',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Post Comment', 'pressmart' ),
                'subtitle' => esc_html__( 'Show post comments and comment form or not.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-post-related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Post', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       	=> 'single-posts-related',
                'type'     	=> 'slider',
                'title'    	=> esc_html__( 'Show Related Posts', 'pressmart' ),
				'subtitle'  => esc_html__( 'Show/display number of related posts.', 'pressmart' ),
                'default'   => 6,
                'min'       => 2,
                'step'      => 1,
                'max'       => 12,
                'display_value' => 'text',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-taxonomy',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Taxonomy', 'pressmart' ),
				'subtitle' => esc_html__( 'Get related posts by post taxonomy category or tag.', 'pressmart' ),
                'options'  => array(
					'post_tag'=>esc_html__( 'Tag', 'pressmart' ),
					'category'=>esc_html__( 'Category', 'pressmart' ),					
				),
                'default'  => 'post_tag',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-orderby',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Orderby', 'pressmart' ),
                'options'  => array(
					'none'=>esc_html__( 'None', 'pressmart' ),
					'rand'=>esc_html__( 'Random', 'pressmart' ),
					'ID'=>esc_html__( 'ID', 'pressmart' ),
					'name'=>esc_html__( 'Name', 'pressmart' ),
					'date'=>esc_html__( 'Date', 'pressmart' ),
					'modified'=>esc_html__( 'Modified Date', 'pressmart' ),					
					'comment_count'=>esc_html__( 'Comment Count', 'pressmart' ),
				),
                'default'  => 'rand',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-order',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Post Order', 'pressmart' ),
                'options'  => array(
					'DESC'=>esc_html__( 'DESC', 'pressmart' ),
					'ASC'=>esc_html__( 'ASC', 'pressmart' ),					
				),
                'default'  => 'DESC',
				'required' => array( 'single-post-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-posts-display',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Display Posts In', 'pressmart' ),
				'subtitle' => esc_html__( 'Display related posts in slider or grid.', 'pressmart' ),
                'options'  => array(
					'slider'=>esc_html__( 'Slider', 'pressmart' ),
					'grid'=>esc_html__( 'Grid', 'pressmart' ),					
				),
                'default'  => 'slider',
				'required' => array( 'single-post-related', '=', 1 ),
            ),			
		)
	) );
	
	/*
	* Portfolio options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Portfolio', 'pressmart' ),
        'id'         => 'portfolio',
		'icon'		 => 'el el-th',
        'fields'     => array(
			array(
                'id'       => 'enable-portfolio',
                'type'     => 'switch',
                'title'    => esc_html__( 'Portfolio', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Enable', 'pressmart' ),
                'off'      => esc_html__( 'Disable', 'pressmart' ),
            ),
			array(
                'id'       => 'portfolio-slug',
                'type'     => 'text',
                'title'    => esc_html__( 'Slug Name', 'pressmart' ),
                'default'  => '',
                'placeholder'  => esc_attr( 'portfolio' ),
            ),
			array(
                'id'       => 'portfolio-name',
                'type'     => 'text',
                'title'    => esc_html__( 'Name', 'pressmart' ),
                'default'  => '',
                'placeholder'  => esc_attr__( 'Portfolios', 'pressmart' ),
            ),
			array(
                'id'       => 'portfolio-singular-name',
                'type'     => 'text',
                'title'    => esc_html__( 'Singular Name', 'pressmart' ),
                'default'  => '',
                'placeholder'  => esc_attr__( 'Portfolio', 'pressmart' ),
            ),
			array(
                'id'       => 'portfolio-cat-slug',
                'type'     => 'text',
                'title'    => esc_html__( 'Category Slug', 'pressmart' ),
                'default'  => '',
                'placeholder'  => esc_attr( 'portfolio_cat' ),
            ),
			array(
                'id'       => 'portfolio-skill-slug',
                'type'     => 'text',
                'title'    => esc_html__( 'Skill Slug', 'pressmart' ),
                'default'  => '',
                'placeholder'  => esc_attr( 'portfolio_skill' ),
            ),
			array(
                'id'       => 'portfolio-meta',
                'type'     => 'switch',
                'title'    => esc_html__( 'Portfolio Meta', 'pressmart' ),
                'default'  => 1,
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
            ),
			array(
                'id'       => 'specific-portfolio-meta',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Specific Portfolio Meta', 'pressmart' ),
                'subtitle' => esc_html__( 'Show/hide specific meta.', 'pressmart' ),
                'multi'    => true,
                'options'  => array(
                    'categories' 	=> esc_html__( 'Category', 'pressmart' ),
                    'skills' 		=> esc_html__( 'Skill', 'pressmart' ),
                ),
                'default'  => array( 'categories', 'skills' ),
				'required' => array( 'portfolio-meta', '=', 1 ),
            ),		
		)
	) );
	
	/*
	* Portfolio Archive Page options
	*/
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Portfolio Archive', 'pressmart' ),
        'id'         => 'portfolio-archive',
		'subsection'	 => true,
        'fields'     => array(
			array(
                'id'       => 'portfolio-page-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Archive Page Layout', 'pressmart' ),
                'desc'     => esc_html__( 'Select portfolio archive page layout with sidebar postion.', 'pressmart' ),
				'options'  => array(
                    'full-width' => array(
                        'alt' => esc_html__( 'Full Width', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' => array(
                        'alt' => esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' => esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  => 'full-width'
            ),
			array(
                'id'       => 'portfolio-sidebar-widget',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar Widget Area', 'pressmart' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'portfolio-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       => 'portfolio-page-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Page Title', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'        => 'portfolio-page-title-text',
                'type'      => 'text',
                'title'     => esc_html__( 'Page Title Text', 'pressmart' ),
                'placeholder' => esc_attr__( 'Enter portfolio title here', 'pressmart' ),
				'default'  	=> 'Portfolio',
				'required' 	=> array( 'portfolio-page-title', '=', 1 )
            ),
			array(
                'id'       => 'portfolio-page-breadcrumb',
                'type'     => 'switch',
                'title'    => esc_html__( 'Page Breadcrumb', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'portfolio-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Portfolio Hover Style', 'pressmart' ),
                'options'  => array(
                    'portfolio-style-1' => array(
                        'alt' => 'Style 1',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/style-1.png',
                    ),
					'portfolio-style-2' => array(
                        'alt' => 'Style 2',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/style-2.png',
                    ),
					'portfolio-style-3' => array(
                        'alt' => 'Style 3',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/style-3.png',
                    ),
				),
				'default'  => 'portfolio-style-1',
			),
			array(
                'id'       => 'portfolio-grid-layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Portfolio Grid Layout', 'pressmart' ),
                'options'  => array(
                    'simple-grid' 	=> esc_html__( 'Simple', 'pressmart' ),
                    'masonry-grid' 	=> esc_html__( 'Masonry', 'pressmart' ),
                ),
                'default'  => 'masonry-grid',
            ),
			array(
                'id'       		=> 'portfolio-grid-columns',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Grid Columns', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many portfolio should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    2 		=> esc_html__( '2', 'pressmart' ),
                    3 		=> esc_html__( '3', 'pressmart' ),
					4 		=> esc_html__( '4', 'pressmart' ),
                ),
                'default'  => 3,
            ),	
			array(
                'id'       		=> 'portfolio-grid-columns-tablet',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns Tablet', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many portfolio should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                    3	 	=> esc_html__( '3', 'pressmart' ),
                ),
                'default'  		=> 2,
            ),
			array(
                'id'       		=> 'portfolio-grid-columns-mobile',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Gird Columns Mobile', 'pressmart' ),
				'subtitle'      => esc_html__( 'How many portfolio should be shown per row?', 'pressmart' ),
                'options'  		=> array(
                    1		=> esc_html__( '1', 'pressmart' ),
                    2		=> esc_html__( '2', 'pressmart' ),
                ),
                'default'  		=> 1,
            ),
			array(
                'id'            => 'portfolio-grid-gap',
                'type'          => 'slider',
                'title'         => esc_html__( 'Grid Gapping', 'pressmart' ),
                'subtitle'      => esc_html__( 'Grid gapping/spacing between portfolio.', 'pressmart' ),
                'default'       => 15,
                'min'           => 0,
                'step'          => 5,
                'max'           => 15,
				'required' => array( 'portfolio-style', '=', array( 'portfolio-style-2', 'portfolio-style-3' ) ),
            ),
			array(
                'id'       => 'portfolio-filter',
                'type'     => 'switch',
                'title'    => esc_html__( 'Portfolio Filter', 'pressmart' ),
				'subtitle' => esc_html__( 'Show portfolios filter or not.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'            => 'portfolio-per-page',
                'type'          => 'slider',
                'title'         => esc_html__( 'Portfolio Per Page', 'pressmart' ),
                'subtitle'      => esc_html__( 'Show number of portfolio per page.', 'pressmart' ),
                'default'       => 9,
                'min'           => 3,
                'step'          => 1,
                'max'           => 50,
                'display_value' => 'text',
            ),
			array(
                'id'       => 'portfolio-button-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Hover Button Icon', 'pressmart' ),
				'subtitle' => esc_html__( 'Portfolio hover button icon show or hide.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'portfolio-link-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Link Button Icon', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
                'default'  => 1,
				'required' => array( 'portfolio-button-icon', '=', 1 ),
            ),
			array(
                'id'       => 'portfolio-zoom-icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Zoom Image Icon', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'portfolio-button-icon', '=', 1 ),
            ),
			array(
                'id'       => 'portfolio-content-part',
                'type'     => 'switch',
                'title'    => esc_html__( 'Portfolio Content Part', 'pressmart' ),
				'subtitle' => esc_html__( 'Portfolio bottom content part( title and category) show or hide.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
				 'default'  => 1,
            ),
			array(
                'id'       => 'portfolio-category',
                'type'     => 'switch',
                'title'    => esc_html__( 'Portfolio Category', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'portfolio-content-part', '=', 1 ),
            ),
			array(
                'id'       => 'portfolio-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Portfolio Title', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
                'off'      => esc_html__( 'Hide', 'pressmart' ),
                'default'  => 1,
				'required' => array( 'portfolio-content-part', '=', 1 ),
            ),
			array(
                'id'       => 'portfolio-pagination-type',
                'type'     => 'button_set',
                'title'    => esc_html__( ' Pagination Style', 'pressmart' ),
                'options'  => array(
					'default'			=> esc_html__( 'Default', 'pressmart' ),
					'infinity-scroll'	=> esc_html__( 'Infinity Scroll', 'pressmart' ),
					'load-more-button'	=> esc_html__( 'Load More', 'pressmart' ),
				),
                'default'  => 'default',
            ),
			array(
                'id'       => 'portfolio-pagination-load-more-button-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Load More Button Text', 'pressmart' ),
				'subtitle' => esc_html__( 'Add Load More Button Text.', 'pressmart' ),
                'default'  => 'Load More Portfolios',
				'required' => array( 'portfolio-pagination-type', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),
			array(
                'id'       => 'portfolio-pagination-finished-message',
                'type'     => 'text',
                'title'    => esc_html__( 'Finished Message', 'pressmart' ),
				'subtitle' => esc_html__( 'Text to display when no additional items are available.', 'pressmart' ),
                'default'  => 'No More Portfolios Available',
				'required' => array( 'portfolio-pagination-type', '=', array( 'infinity-scroll', 'load-more-button' ) ),
            ),		
		)
	) );
	
	/*
	* Single Portfolio options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Portfolio', 'pressmart' ),
        'id'         => 'single-portfolio',
		'subsection'	 => true,
        'fields'     => array(
			array(
                'id'       => 'single-portfolio-page-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Page Layout', 'pressmart' ),
                'subtitle' => esc_html__( 'Select single post sidebar layout.', 'pressmart' ),
				'options'  => array(
                    'full-width' => array(
                        'alt' => esc_html__( 'Full Width', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
                    ),                   
                    'left-sidebar' => array(
                        'alt' => esc_html__( 'Left Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
                    ), 
					'right-sidebar' => array(
                        'alt' => esc_html__( 'Right Sidebar', 'pressmart' ),
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
                    ), 
                ),
                'default'  => 'full-width'
            ),
			array(
                'id'       => 'single-portfolio-sidebar-widget',
                'type'     => 'select',
                'title'    => esc_html__( 'Sidebar Widget Area', 'pressmart' ),
                'data'     => 'sidebars',
                'default'  => 'sidebar-1',
                'required' => array( 'single-portfolio-page-layout', '=', array( 'left-sidebar', 'right-sidebar' ) )
            ),
			array(
                'id'       => 'single-portfolio-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Portfolio Layout', 'pressmart' ),
               'options'  => array(
                    '4' 	=> array(
                        'alt' => '4 8 Column',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/4_8-layout.png',
                    ),
					'6' 	=> array(
                        'alt' => '6 6 Column',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/6_6-layout.png',
                    ),                   
                    '8' => array(
                        'alt' => '8 4 Column',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/8_4-layout.png',
                    ), 
					'12' => array(
                        'alt' => '12 12 Column',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/portfolio/12_12-layout.png',
                    ),
                ),
                'default'  => '8',
            ),
			array(
                'id'       => 'single-portfolio-gallery',
                'type'     => 'switch',
                'title'    => esc_html__( 'Thumbnail/Gallery', 'pressmart' ),
                'subtitle' => esc_html__( 'Show/hide portfolio thumbnail/gallery.', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-gallery-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Gallery Style', 'pressmart' ),
                'options'  => array(
					'slider'		=>esc_html__( 'Slider', 'pressmart' ),
					'grid'			=>esc_html__( 'Grid', 'pressmart' ),
					'one-column'	=>esc_html__( 'One Column', 'pressmart' ),					
				),
                'default'  => 'slider',
				'required' => array( 'single-portfolio-gallery', '=', 1 )
            ),
			array(
                'id'       => 'single-portfolio-information-title',
                'type'     => 'switch',
                'title'    => esc_html__( 'Information Title', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-description',
                'type'     => 'switch',
                'title'    => esc_html__( 'Project Description', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-preview-button',
                'type'     => 'switch',
                'title'    => esc_html__( 'Preview Button', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-client',
                'type'     => 'switch',
                'title'    => esc_html__( 'Project Client', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-date',
                'type'     => 'switch',
                'title'    => esc_html__( 'Project Date', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-category',
                'type'     => 'switch',
                'title'    => esc_html__( 'Project Category', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-skill',
                'type'     => 'switch',
                'title'    => esc_html__( 'Project Skill', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-share',
                'type'     => 'switch',
                'title'    => esc_html__( 'Social Share Links', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Project Navigation', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-comments',
                'type'     => 'switch',
                'title'    => esc_html__( 'Comment', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'single-portfolio-related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Projects', 'pressmart' ),
                'on'       => esc_html__( 'Show', 'pressmart' ),
				'off'      => esc_html__( 'Hide', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       	=> 'show-related-portfolios',
                'type'     	=> 'slider',
                'title'    	=> esc_html__( 'Show Related Portfolios', 'pressmart' ),
				'subtitle'  => esc_html__( 'Show/display number of related Portfolios.', 'pressmart' ),
                'default'   => 6,
                'min'       => 2,
                'step'      => 1,
                'max'       => 12,
                'display_value' => 'text',
				'required' => array( 'single-portfolio-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-portfolios-taxonomy',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Taxonomy', 'pressmart' ),
				'subtitle' => esc_html__( 'Get related Portfolios by post taxonomy category or skill.', 'pressmart' ),
                'options'  => array(
					'portfolio_cat'=>esc_html__( 'Category', 'pressmart' ),
					'portfolio_skill'=>esc_html__( 'Skill', 'pressmart' ),					
				),
                'default'  => 'portfolio_cat',
				'required' => array( 'single-portfolio-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-Portfolios-orderby',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Portfolios Orderby', 'pressmart' ),
                'options'  => array(
					'none'=>esc_html__( 'None', 'pressmart' ),
					'rand'=>esc_html__( 'Random', 'pressmart' ),
					'ID'=>esc_html__( 'ID', 'pressmart' ),
					'name'=>esc_html__( 'Name', 'pressmart' ),
					'date'=>esc_html__( 'Date', 'pressmart' ),
					'modified'=>esc_html__( 'Modified Date', 'pressmart' ),					
					'comment_count'=>esc_html__( 'Comment Count', 'pressmart' ),
				),
                'default'  => 'rand',
				'required' => array( 'single-portfolio-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-portfolios-order',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Portfolios Order', 'pressmart' ),
                'options'  => array(
					'DESC'=>esc_html__( 'DESC', 'pressmart' ),
					'ASC'=>esc_html__( 'ASC', 'pressmart' ),					
				),
                'default'  => 'DESC',
				'required' => array( 'single-portfolio-related', '=', 1 ),
            ),
			array(
                'id'       => 'related-portfolios-display',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Display Portfolios In', 'pressmart' ),
				'subtitle' => esc_html__( 'Display related portfolios in slider or grid.', 'pressmart' ),
                'options'  => array(
					'slider'=>esc_html__( 'Slider', 'pressmart' ),
					'grid'=>esc_html__( 'Grid', 'pressmart' ),					
				),
                'default'  => 'slider',
				'required' => array( 'single-portfolio-related', '=', 1 ),
            ),
		)
	) );
	
	/*
	* Social
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social', 'pressmart' ),
        'id'         => 'social',
		'icon'		 => 'el el-group',
        'fields'     => array(
		)
	) );
	
	/*
	* Social Profile
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social Profile', 'pressmart' ),
        'id'         => 'social-profile-section',
		'icon'		 => '',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'social-profile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Social Profile Icon', 'pressmart' ),
				'subtitle' => esc_html__( 'Show social profile icon in header and footer.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'social-profile-icons-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Icons Style', 'pressmart' ),
                'options'  => array(
					'icons-default' 	=> array(
                        'title' => 'Default',
                        'alt' => 'Default',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/default.png',
                    ),
					'icons-colour'	=> array(
                        'title' => 'Colour',
                        'alt' => 'Colour',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/colour.png',
                    ),                   
                    'icons-bordered'  => array(
                        'title' => 'Bordered',
                        'alt' => 'Bordered',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/bordered.png',
                    ), 
					'icons-fill-colour' => array(
                        'title' => 'Fill Colour',
                        'alt' => 'Fill Colour',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/fill-color.png',
                    ),
					'icons-theme-colour' => array(
                        'title' => 'Theme Colour',
                        'alt' => 'Theme Colour',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/theme-color.png',
                    ),
										
                ),
                'default'  => 'icons-default',
				'required' => array( 'social-profile', '=', 1 )
            ),
			array(
                'id'       => 'profile-icons-size',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Icons Size', 'pressmart' ),
                'options'  => array(
                    'icons-size-default'=> esc_html__( 'Default', 'pressmart' ),
					'icons-size-small' 	=> esc_html__( 'Small', 'pressmart' ),
					'icons-size-large' 	=> esc_html__( 'Large', 'pressmart' ),
                ),
                'default'  => 'icons-size-default',
				'required' => array( 'social-profile', '=', 1 )
            ),
			array(
                'id'       => 'facebook-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Facebook', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the facebook icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'twitter-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Twitter', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the twitter icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'instagram-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Instagram', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the instagram icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'linkedin-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Linkedin', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the linkedin icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'flickr-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Flickr', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the flickr icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),			
			array(
                'id'       => 'rss-link',
                'type'     => 'text',
                'title'    => esc_html__( 'RSS', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the rss icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'pinterest-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Pinterest', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the pinterest icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'youtube-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Youtube', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the youtube icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '#',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'tiktok-link',
                'type'     => 'text',
                'title'    => esc_html__( 'TikTok', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the tiktok icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'github-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Github', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the github icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'whatsapp-link',
                'type'     => 'text',
                'title'    => esc_html__( 'WhatsApp', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the whatsapp icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'telegram-link',
                'type'     => 'text',
                'title'    => esc_html__( 'Telegram', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the telegram icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
			array(
                'id'       => 'vk-link',
                'type'     => 'text',
                'title'    => esc_html__( 'VK', 'pressmart' ),
                'subtitle' => esc_html__( 'Enter your custom link to show the VK icon. Leave blank to hide icon.', 'pressmart' ),
				'default'  => '',
				'required' => array( 'social-profile', '=', 1 ),
            ),
		)
	) );
	
	/*
	* Social Share
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Social Share', 'pressmart' ),
        'id'         => 'social-share-section',
		'icon'		 => '',
		'subsection' => true,
        'fields'     => array(
			array(
                'id'       => 'social-sharing',
                'type'     => 'switch',
                'title'    => esc_html__( 'Share Icons', 'pressmart' ),
				'subtitle' => esc_html__( 'Show social share icons in blog, posts, products, portfolios, etc...', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'social-sharing-icons-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Icons Style', 'pressmart' ),
                'options'  => array(
					'icons-default' 	=> array(
                        'title' => 'Default',
                        'alt' => 'Default',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/default.png',
                    ),
					'icons-colour'	=> array(
                        'title' => 'Colour',
                        'alt' => 'Colour',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/colour.png',
                    ),                   
                    'icons-bordered'  => array(
                        'title' => 'Bordered',
                        'alt' => 'Bordered',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/bordered.png',
                    ), 
					'icons-fill-colour' => array(
                        'title' => 'Fill Colour',
                        'alt' => 'Fill Colour',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/fill-color.png',
                    ),
					'icons-theme-colour' => array(
                        'title' => 'Theme Colour',
                        'alt' => 'Theme Colour',
                        'img' => PRESSMART_ADMIN_IMAGES . 'layout/social-icon/theme-color.png',
                    ),
										
                ),
                'default'  => 'icons-bordered',
				'required' => array( 'social-sharing', '=', 1 )
            ),
			array(
                'id'       => 'sharing-icons-shape',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Icons Shape', 'pressmart' ),
                'options'  => array(
					'icons-shape-circle' => esc_html__( 'Circle', 'pressmart' ),
                    'icons-shape-square' => esc_html__( 'Square', 'pressmart' ),
                ),
                'default'  => 'icons-shape-circle',
				'required' => array( 'social-sharing', '=', 1 )
            ),
			array(
                'id'       => 'sharing-icons-size',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Icons Size', 'pressmart' ),
                'options'  => array(
                    'icons-size-default'=> esc_html__( 'Default', 'pressmart' ),
					'icons-size-small' 	=> esc_html__( 'Small', 'pressmart' ),
					'icons-size-large' 	=> esc_html__( 'Large', 'pressmart' ),
                ),
                'default'  => 'icons-size-default',
				'required' => array( 'social-sharing', '=', 1 )
            ),
			array(
                'id'       => 'social-share-manager',
                'type'     => 'sorter',
                'title'    => 'Share Icons Manager',
                'compiler' => 'true',
                'options'  => array(
                    'enabled'  => array(
                        'facebook' 		=> 'Facebook',
                        'twitter'     	=> 'Twitter',
                        'linkedin'   	=> 'Linkedin',
						'telegram'		=> 'Telegram',
						'pinterest'		=> 'Pinterest',
                    ),
                    'disabled' => array(
						'stumbleupon'	=> 'StumbleUpon',
						'tumblr'   		=> 'Tumblr',
						'reddit'   		=> 'Reddit',
						'vk'   			=> 'VK',
						'odnoklassniki' => 'Odnoklassniki',
						'pocket'   		=> 'Pocket',
						'whatsapp'  	=> 'WhatsApp',
						'email'   		=> 'Email',
						'print'   		=> 'Print',
					),
                ),
				'required' => array( 'social-sharing', '=', 1 )
            ),			
		)
	) );/* End Social sections */
	
	/*
	* Newsletter Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Newsletter', 'pressmart' ),
        'id'         => 'newsletter',
		'icon'       => 'el el-envelope',
        'fields'     => array(
			array(
                'id'       => 'newsletter-popup',
                'type'     => 'switch',
                'title'    => esc_html__( 'Newsletter', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Newsletter popup enable or disable in your site.', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       			=> 'newsletter-popup-on',
                'type'     			=> 'button_set',
                'title'    			=> esc_html__( 'Newsletter Popup On', 'pressmart' ),
                'subtitle' 	   		=> esc_html__( 'Show newsletter popup on front page or all pages.', 'pressmart' ),
                'options'  			=> array(
                    'front-page' 	=> esc_html__( 'Front Page', 'pressmart' ),
                    'all-pages' 	=> esc_html__( 'All Pages', 'pressmart' ),
                ),
                'default'  			=> 'all-pages',
            ),
			array(
                'id'       => 'newsletter-show-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Mobile', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'subtitle' => esc_html__( 'You want to show newsletter for mobile devices.', 'pressmart' ),
				'default'  => 1,
            ),
			array(
				'id'      	=> 'newsletter-when-appear',
				'type'    	=> 'button_set',
				'title'   	=> esc_html__( 'When Popup Appear?', 'pressmart' ),                    
				'options' 	=> array(
					'page_load' 	=> esc_html__( 'On Page Load', 'pressmart' ),
					'scroll' 		=> esc_html__( 'When Page Scroll', 'pressmart' ),
					'exit' 			=> esc_html__( 'On Exit Intent', 'pressmart' ),
				), 
				'default' 	=> 'page_load',
			),
			array(
				'id'       => 'newsletter-delay',
				'type'     => 'text',
				'title'    => esc_html__( 'Popup Delay', 'pressmart' ),
				'default'  => '5',
				'subtitle' =>  esc_html__( 'Enter no of second to open popup after page load.', 'pressmart' ),
				'required' => array( 'newsletter-when-appear', '=', 'page_load' ),
			),
			array(
				'id'       => 'newsletter-version',
				'type'     => 'text',
				'title'    => esc_html__( 'Popup Version', 'pressmart' ),
				'default'  => '1',
				'subtitle' =>  esc_html__( 'Increase version number, for show forcefully popup who already closed it.', 'pressmart' ),
			),
			array(
				'id'       => 'newsletter-x-scroll',
				'type'     => 'text',
				'title'    => esc_html__( 'Open When User Scroll % of Page', 'pressmart' ),
				'default'  => '30',
				'subtitle' =>  esc_html__( '100% - For end of page', 'pressmart' ),
				'required' => array( 'newsletter-when-appear', '=', 'scroll' ),
			),
			array(
                'id'       => 'newsletter-logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Newsletter Logo', 'pressmart' ),
                'compiler' => 'true',
                'subtitle' =>  esc_html__( 'Upload newsletter logo.', 'pressmart' ),
                'default'  => array(),
				'required' => array( 'newsletter-popup', '=', 1 ),
            ),
			array(
                'id'       => 'newsletter-title',
                'type'     => 'text',
                'title'    => esc_html__( 'Newsletter Title', 'pressmart' ),
				'default'  => esc_html__( 'Upto 45% Off!', 'pressmart' ),
            ),
			array(
                'id'       => 'newsletter-tag-line',
                'type'     => 'editor',
                'title'    => esc_html__( 'Newsletter Tag Line', 'pressmart' ),
				'default'  => esc_html__( 'Subscribe today and get special offers, coupons and top news.', 'pressmart' ),
            ),
			array(
                'id'       => 'newsletter-dont-show',
                'type'     => 'text',
                'title'    => esc_html__( 'Newsletter Don\'t Show Msg', 'pressmart' ),
				'default'  => esc_html__( 'Don\'t show this popup again', 'pressmart' ),
            ),			
			array(
                'id'    => 'newsletter-popup-layout',
                'type'   => 'info',
                'notice' => false,
                'title' => esc_html__( 'Newsletter Layout & Style', 'pressmart' ),
            ),
			array(
                'id'       		=> 'newsletter-layout',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Newsletter Layout', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Select newsletter popup layout.', 'pressmart' ),
				'options'  		=> array(
                    'full-content' 	=> array(
                        'title' 	=> esc_html__( 'Full Content', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/newsletter-full-content.png',
                    ),
                    'banner-left' 	=> array(
                        'title' 	=> esc_html__( 'Banner Left', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/newsletter-banner-left.png',
                    ),
					'banner-right' 	=> array(
                        'title' 	=> esc_html__( 'Banner Right', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/newsletter-banner-right.png',
                    ),
                ),
                'default'  => 'banner-left',
            ),
			array(
                'id'       => 'newsletter-banner',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Newsletter Banner', 'pressmart' ),
                'compiler' => 'true',
                'subtitle' =>  esc_html__( 'Upload newsletter banner.', 'pressmart' ),
                'default'  => array(),
				'required' => array( 'newsletter-layout', '=', array ( 'banner-left', 'banner-right' ) ),
            ),
			array(
                'id'            	=> 'newsletter-popup-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Newsletter Width (px)', 'pressmart' ),
				'subtitle'          => esc_html__( 'Newsletter popup width in pixels', 'pressmart' ),
				'output'   			=> array( '.pressmart-newsletter-popup' ),
                'default'       	=> 750,
                'min'           	=> 300,
                'step'          	=> 1,
                'max'           	=> 840,
            ),
			array(
				'id'             	=> 'newsletter-content-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Content Padding', 'pressmart' ),
				'subtitle'       	=> esc_html__( 'Set newsletter content padding.', 'pressmart' ),
				'mode'           	=> 'padding',
				'units_extended' 	=> 'false',
				'units'          	=> array('rem', '%', 'px'),
				'output' 			=> array( '.pressmart-newsletter-content' ),
				'default'            => array(
					'padding-top'     	=> '2', 
					'padding-right'    	=> '2', 
					'padding-bottom'  	=> '2',
					'padding-left'  	=> '2',
					'units'          	=> 'rem', 
				),
			),
			array(
                'id'       		=> 'newsletter-form-style',
                'type'     		=> 'image_select',
                'title'    		=> esc_html__( 'Newsletter Form Style', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Select newsletter form style.', 'pressmart' ),
				'options'  		=> array(
                    'overlay-form' 		=> array(
                        'title' 	=> esc_html__( 'Overlay Form', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/overlay-form.png',
                    ),
                    'simple-form' 		=> array(
                        'title' 	=> esc_html__( 'Simple Form', 'pressmart' ),
                        'img' 		=> PRESSMART_ADMIN_IMAGES . 'layout/simple-form.png',
                    ),
                ),
                'default'  => 'overlay-form',
            ),
			array(
                'id'       		=> 'newsletter-field-shape',
                'type'     		=> 'button_set',
                'title'    		=> esc_html__( 'Field Shape', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Select newsletter form field shape.', 'pressmart' ),
                'options'  		=> array(
					'shape-round' 	=> esc_html__( 'Round', 'pressmart' ),
                    'shape-square' 	=> esc_html__( 'Square', 'pressmart' ),
                ),
                'default'  		=> 'shape-round',
				'required' 		=> array( 'social-sharing', '=', 1 )
            ),
			array(
                'id'		=> 'newsletter-popup-color',
                'type'		=> 'info',
                'notice'	=> false,
                'title'		=> esc_html__( 'Newsletter Colors', 'pressmart' ),
            ),
			array(
                'id'       		=> 'newsletter-background',
                'type'     		=> 'background',
                'title'    		=> esc_html__( 'Background Color', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Newsletter background with image, color, etc.', 'pressmart' ),
				'output'   		=> array( '.pressmart-newsletter-content' ),
                'default'  		=> array(
					'background-color' 		=> '#059473',
					'background-image' 		=> '',
					'background-repeat' 	=> '',
					'background-size' 		=> '',
					'background-attachment' => '',
					'background-position' 	=> '',
				),
            ),
            array(
                'id'       		=> 'newsletter-text-color',
                'type'     		=> 'color',
                'title'    		=> esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Set text color', 'pressmart' ),
                'default'  		=> '#ffffff',
            ),
			array(
                'id'       		=> 'newsletter-button-bg-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Background Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Set button background color', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#9e7856',
                    'hover'   	=> '#9e7856',
                ),
            ),
			array(
                'id'       		=> 'newsletter-button-text-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Set button text color', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#f1f1f1',
                ),
            ),
			array(
                'id'       		=> 'newsletter-border',
                'type'     		=> 'border',
                'title'    		=> esc_html__( 'Border', 'pressmart' ),                
                'subtitle' 		=> esc_html__( 'Set border color, style and width.', 'pressmart' ),
                'default'  		=> array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                ),
            ),
			array(
                'id'            => 'newsletter-border-radius',
                'type'          => 'slider',
                'title'         => esc_html__( 'Border Radius', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Newsletter popup border radius.', 'pressmart' ),
                'default'       => 0,
                'min'           => 0,
                'step'          => 1,
                'max'           => 22,
                'display_value' => 'label'
            ),
		)
	) );

	/*
	* Cookie Options
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Cookie Notice', 'pressmart' ),
        'id'         => 'section-cookie-notice',
		'icon'       => 'el el-dashboard',
        'fields'     => array(
			array(
                'id'       => 'cookie-notice',
                'type'     => 'switch',
                'title'    => esc_html__( 'Cookie', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Cookie notice enable or disable in your site.', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-title',
                'type'     => 'text',
                'title'    => 'Cookie Title',
                'subtitle' => esc_html__( 'Enter the Cookie Title/Name.', 'pressmart' ),
				'default'  => esc_html__( 'Cookies Notice', 'pressmart' ),
            ),
			array(
                'id'       => 'cookie-message-text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Message', 'pressmart' ),
				'subtitle' => esc_html__( 'Enter the cookie notice message.', 'pressmart' ),
				'default'  => esc_html__( 'We use cookies to ensure that we give you the best experience on our website. If you continue to use this site we will assume that you are happy with it.', 'pressmart' ),
            ),
			array(
                'id'       => 'cookie-accept-text',
                'type'     => 'text',
                'title'    => esc_html__( 'Button Text', 'pressmart' ),
                'subtitle' => esc_html__( 'The text of the option to accept the usage of the cookies and make the notification disappear.', 'pressmart' ),
				'default'  => esc_html__( 'Yes, I\'m Accept', 'pressmart' ),
            ),
			array(
                'id'       => 'cookie-see-more-opt',
                'type'     => 'switch',
                'title'    => esc_html__( 'More Info Link', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Enable Read more link.', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-see-more-text',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'The text of the more info button.', 'pressmart' ),
				'default'  => esc_html__( 'Read more', 'pressmart' ),
				'required' => array( 'cookie-see-more-opt', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-see-more-link-type',
                'type'     => 'radio',
                'title'    => '',
                'subtitle' => esc_html__( 'Select where to redirect user for more information about cookies.', 'pressmart' ),
                'options'  => array(
								'custom' 	 => esc_html__( 'Custom link', 'pressmart' ),
								'page' => esc_html__( 'Page link', 'pressmart' ),
							),
				'default'  => 'custom',
				'required' => array( 'cookie-see-more-opt', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-see-more-link-custom',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'Enter the full URL starting with http://', 'pressmart' ),
				'default'  => 'http://empty',
				'placeholder' => esc_attr( 'http://#' ),
				'required' => array( 'cookie-see-more-link-type', '=', 'custom' ),
            ),
			array(
                'id'       => 'cookie-see-more-link-pages',
                'type'     => 'select',
                'data'     => 'pages',
                'title'    => '',
                'subtitle' => esc_html__( 'Select from one of your site\'s pages', 'pressmart' ),
				'required' => array( 'cookie-see-more-link-type', '=', 'page' ),
            ),
			array(
                'id'       => 'cookie-see-more-link-target',
                'type'     => 'select',
                'title'    => esc_html__( 'Link Target', 'pressmart' ),
                'subtitle' => esc_html__( 'Select the link target for more info page.', 'pressmart' ),
                'options'  => array(
                    '_blank' 	=> esc_html__( 'New Page', 'pressmart' ),
                    '_self' 	=> esc_html__( 'This page', 'pressmart' ),
                ),
                'default'  => '_blank',
            ),
			array(
                'id'       => 'cookie-refuse-opt',
                'type'     => 'switch',
                'title'    => esc_html__( 'Refuse Button', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Give to the user the possibility to refuse third party non functional cookies.', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-refuse-text',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'The text of the option to refuse the usage of the cookies. To get the cookie notice status use pressmart_cn_cookies_accepted() function.', 'pressmart' ),
				'default'  => esc_html__( 'Dismiss', 'pressmart' ),
				'required' => array( 'cookie-refuse-opt', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-refuse-code',
                'type'     => 'textarea',
                'title'    => '',
				'subtitle' => esc_html__( 'Enter non functional cookies Javascript code here (for e.g. Google Analytics). It will be used after cookies are accepted.', 'pressmart' ),
				'required' => array( 'cookie-refuse-opt', '=', 1 ),
				
            ),
			array(
                'id'       => 'cookie-on-scroll',
                'type'     => 'switch',
                'title'    => esc_html__( 'On Scroll', 'pressmart' ),
                'on'       => esc_html__( 'Enable', 'pressmart' ),
				'off'      => esc_html__( 'Disable', 'pressmart' ),
				'subtitle' => esc_html__( 'Enable cookie notice acceptance when users scroll.', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'cookie-on-scroll-offset',
                'type'     => 'text',
                'title'    => '',
                'subtitle' => esc_html__( 'Number of pixels user has to scroll to accept the usage of the cookies and make the notification disappear.', 'pressmart' ),
				'default'  => 100,
				'required' => array( 'cookie-on-scroll', '=', 1 ),
            ),
			array(
                'id'       => 'cookie-expiry-times',
                'type'     => 'select',
                'title'    => esc_html__( 'Cookie Expiry', 'pressmart' ),
                'subtitle' => esc_html__( 'Select the link target for more info page.', 'pressmart' ),
                'options'  => array(
					'86400'	 	=> esc_html__( '1 day', 'pressmart' ),
					'604800'	=> esc_html__( '1 week', 'pressmart' ),
					'2592000'	=> esc_html__( '1 month', 'pressmart' ),
					'7862400'	=> esc_html__( '3 months', 'pressmart' ),
					'15811200'	=> esc_html__( '6 months', 'pressmart' ),
					'31536000'	=> esc_html__( '1 year', 'pressmart' ),
					'31337313373' => esc_html__( 'infinity', 'pressmart' ),
                ),
                'default'  => '2592000',
            ),
			array(
                'id'       => 'cookie-script-placements',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Script Placement', 'pressmart' ),
                'subtitle' => esc_html__( 'Select where all the plugin scripts should be placed.', 'pressmart' ),
                'options'  => array(
                    'header' => esc_html__( 'Header', 'pressmart' ),
                    'footer' => esc_html__( 'Footer', 'pressmart' ),
                ),
                'default'  => 'footer',
            ),
			array(
                'id'       => 'cookie-positions',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Position', 'pressmart' ),
                'subtitle' => esc_html__( 'Select location for your cookie notice.', 'pressmart' ),
                'options'  => array(
                    'top' 		=> esc_html__( 'Top', 'pressmart' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'pressmart' ),
                ),
                'default'  => 'bottom'
            ),
			array(
                'id'       => 'cookie-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Cookie Style', 'pressmart' ),
                'subtitle' => esc_html__( 'Select style of cookie notice on bottom.', 'pressmart' ),
                'options'  => array(
                    'bar' 		=> esc_html__( 'Bar', 'pressmart' ),
                    'box' 	=> esc_html__( 'Box', 'pressmart' ),
                ),
                'default'  => 'bar',
				'required' => array( 'cookie-positions', '=', 'bottom' ),
            ),
			array(
                'id'       => 'cookie-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
                'default'  => '#212121',
            ),
			array(
                'id'       => 'cookie-background-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Bar Background Color', 'pressmart' ),
                'default'  => '#f8f8f8',
            ),
		)
	) );
	
	
	/*
	* Slider Config
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Slider Config', 'pressmart' ),
        'id'         => 'slider-config',
		'icon'		 => 'el el-picture',
        'fields'     => array(
			array(
                'id'       => 'slider-loop',
                'type'     => 'switch',
                'title'    => esc_html__( 'Loop', 'pressmart' ),
				'subtitle' => esc_html__( 'Infinity loop. Duplicate last and first items to get loop illusion.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-autoplay',
                'type'     => 'switch',
                'title'    => esc_html__( 'Autoplay', 'pressmart' ),
                'subtitle' => esc_html__( 'Autoplay.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),			
			array(
                'id'       => 'slider-autoplay-hover-pause',
                'type'     => 'switch',
                'title'    => esc_html__( 'autoplayHoverPause', 'pressmart' ),
				'subtitle' => esc_html__( 'Pause on mouse hover.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
				'required' => array( 'slider-autoplay', '=', 1 )
            ),
			array(
                'id'       => 'slider-autoplaytimeout',
                'type'     => 'text',
                'title'    => esc_html__( 'autoplayTimeout', 'pressmart' ),
				'subtitle' => esc_html__( 'Autoplay interval timeout.', 'pressmart' ),
                'default'  => 3500,
				'validate' => 'numeric',
				'required' => array( 'slider-autoplay', '=', 1 )
            ),
			array(
                'id'       => 'slider-center',
                'type'     => 'switch',
                'title'    => esc_html__( 'Center', 'pressmart' ),
				'subtitle' => esc_html__( 'Center item. Works well with even an odd number of items.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-smartspeed',
                'type'     => 'text',
                'title'    => esc_html__( 'smartSpeed', 'pressmart' ),
				'subtitle' => esc_html__( 'Speed Calculate. More info to come..', 'pressmart' ),
                'default'  => 750,
				'validate' => 'numeric',
            ),			
			array(
                'id'       => 'slider-rewind',
                'type'     => 'switch',
                'title'    => esc_html__( 'Rewind', 'pressmart' ),
				'subtitle' => esc_html__( 'Go backwards when the boundary has reached.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-auto-height',
                'type'     => 'switch',
                'title'    => esc_html__( 'AutoHeight', 'pressmart' ),
                'subtitle' => esc_html__( 'AutoHeight.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Navigation', 'pressmart' ),
				'subtitle' => esc_html__( 'Show next/prev navigation.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'slider-navigation-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'Navigation in Mobile', 'pressmart' ),
				'subtitle' => esc_html__( 'Show next/prev navigation in mobile.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-dots-navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Dots Navigation', 'pressmart' ),
				'subtitle' => esc_html__( 'Show dots navigation.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'slider-touchDrag',
                'type'     => 'switch',
                'title'    => esc_html__( 'TouchDrag', 'pressmart' ),
				'subtitle' => esc_html__( 'Touch drag enabled.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 0,
            ),
			array(
                'id'       => 'slider-touchDrag-mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'TouchDrag In Mobile', 'pressmart' ),
				'subtitle' => esc_html__( 'Touch drag enabled in mobile.', 'pressmart' ),
                'on'       => esc_html__( 'Yes', 'pressmart' ),
				'off'      => esc_html__( 'No', 'pressmart' ),
				'default'  => 1,
            ),
			array(
                'id'       => 'slider-animate-in',
                'type'     => 'text',
                'title'    => esc_html__( 'Animate In', 'pressmart' ),
				'subtitle' => wp_kses( sprintf( __( 'Please input animation. Please reference <a href="%s" target="_blank">animate.css</a>. ex: fadeIn', 'pressmart' ), esc_url( 'http://daneden.github.io/animate.css' ) ),
				array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
                'default'  => '',
            ),
			array(
                'id'       => 'slider-animate-out',
                'type'     => 'text',
                'title'    => esc_html__( 'Animate Out', 'pressmart' ),
				'subtitle' => wp_kses( sprintf( __( 'Please input animation. Please reference <a href="%s" target="_blank">animate.css</a>. ex: fadeIn', 'pressmart' ), esc_url( 'http://daneden.github.io/animate.css' ) ),
				array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
						),
					) 
				),
                'default'  => '',
            ),
		)
	) );/* END SLIDER CONFIG SECTIONS */
	
	/*
	* Optimize
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Optimize(Performance)', 'pressmart' ),
        'id'         => 'site-optimize',
		'icon'		 => 'el el-dashboard',
        'fields'     => array(
			array(
                'id'       		=> 'disable-fontawesome',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Font Awesome', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Disable font awesome style from plugins.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 1,
            ),
			array(
                'id'       		=> 'disable-gutenberg',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Gutenberg', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Disable gutenberg styles.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 0,
            ),
			array(
                'id'       		=> 'disable-wc-blocks',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'WC Blocks', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Disable default WooCommerce blocks styles.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
                'off'      		=> esc_html__( 'No', 'pressmart' ),
                'default'  		=> 0,
            ),
		)
	) );
	
	/*
	* Maintenance Mode
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Maintenance Mode', 'pressmart' ),
        'id'         => 'site-maintenance-mode',
		'icon'		 => 'el el-icon-website',
        'fields'     => array(
			array(
                'id'       		=> 'maintenance-mode',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Maintenance Mode', 'pressmart' ),
				'subtitle'		=> esc_html__( 'Status of Maintenance Mode.', 'pressmart' ),
                'default'  		=> 0,
                'on'       		=> esc_html__( 'On', 'pressmart' ),
                'off'      		=> esc_html__( 'Off', 'pressmart' ),
            ),
			array(
				'id'      	=> 'maintenance-page',
				'type'    	=> 'select',
				'title'   	=> esc_html__( 'Page', 'pressmart' ),
				'subtitle'	=> esc_html__( 'Select page to display as maintenance page.', 'pressmart' ),
				'data'    	=> 'pages',
			),
		)
	) );
	
	/*
	* White Label
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'White Label', 'pressmart' ),
        'id'         => 'white-label',
		'icon'       => 'el el-tag',
        'fields'     => array(
			array(
                'id'       		=> 'white-label-enable',
                'type'     		=> 'switch',
                'title'    		=> esc_html__('Enable White Label?','pressmart'),
                'on'       		=> esc_html__('Enable','pressmart'),
				'off'      		=> esc_html__('Disable','pressmart'),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'theme-name',
                'type'     		=> 'text',
                'title'    		=> esc_html__( 'Theme Name', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Replace all the theme name in admin dashboard.', 'pressmart' ),
            ),
			array(
                'id'       			=> 'theme-screenshot',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Theme Screenshot', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Replace the theme screenshot in Appearance > Themes. Recommended size 1200x900px.', 'pressmart' ),
				'default'  			=> array(),
			),
			array(
                'id'       			=> 'theme-menu-icon',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Theme Menu Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Replace the theme menu icon. Recommended size 32x32px.', 'pressmart' ),
				'default'  			=> array(),
			),
			array(
                'id'       			=> 'theme-welcome-page-title',
                'type'     			=> 'text',
                'title'    			=> esc_html__( 'Welcome Page Title', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Replace the theme welcome page title.', 'pressmart' ),
				'default'  			=> '',
			),
			array(
                'id'       			=> 'theme-welcome-page-description',
                'type'     			=> 'textarea',
                'title'    			=> esc_html__( 'Welcome Page Description','pressmart'),
                'subtitle'     		=> esc_html__( 'Replace the theme welcome page description.', 'pressmart' ),
				'default'  			=> '',
            ),
			array(
                'id'       			=> 'theme-welcome-page-icon',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Welcome Page Icon', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Replace the theme welcome page icon. Recommended size 150x150px.', 'pressmart' ),
				'default'  			=> array()
			),
			array(
                'id'       		=> 'disable-welcome-page',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Disable Welcome Menu','pressmart' ),
                'subtitle'     	=> esc_html__( 'Disable welcome/dashboard menu.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'       		=> 'disable-demo-import',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Disable Demo Import Menu','pressmart' ),
                'subtitle'     	=> esc_html__( 'Disable Demo Import Menu.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 0,
            ),
			array(
                'id'    	=> 'section-wodpress-login-page',
                'type'   	=> 'info',
                'notice' 	=> false,
                'title' 	=> esc_html__( 'WordPress Login Page Design', 'pressmart' ),
            ),
			array(
                'id'       			=> 'wp-login-page-logo',
                'type'     			=> 'media',
                'url'      			=> false,
                'title'    			=> esc_html__( 'Wordpress Logo', 'pressmart' ),
                'subtitle'     		=> esc_html__( 'Replace the wordpress logo.', 'pressmart' ),
				'default'  			=> array()
			),
			array(
                'id'            	=> 'wp-login-page-logo-width',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Logo Width', 'pressmart' ),
				'subtitle'          => esc_html__( 'Logo width in pixels', 'pressmart' ),
                'default'       	=> 150,
                'min'           	=> 50,
                'step'          	=> 1,
                'max'           	=> 300,
                'display_value' 	=> 'text',
            ),
			array(
                'id'            	=> 'wp-login-page-logo-height',
                'type'          	=> 'slider',
                'title'         	=> esc_html__( 'Logo Height', 'pressmart' ),
				'subtitle'          => esc_html__( 'Logo height in pixels', 'pressmart' ),
                'default'       	=> 84,
                'min'           	=> 25,
                'step'          	=> 1,
                'max'           	=> 250,
                'display_value' 	=> 'text',
            ),
			array(
                'id'       		=> 'wp-login-page-background',
                'type'    	 	=> 'background',
                'title'    		=> esc_html__( 'Page Background', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Set wordpress login page background.', 'pressmart' ),
                'default'  		=> array(
					'background-color' => '#f0f0f1'
				),
            ),
			
			array(
                'id'       		=> 'wp-login-form-background',
                'type'    	 	=> 'color',
                'title'    		=> esc_html__( 'Login Form Background', 'pressmart' ),
                'subtitle'     	=> esc_html__( 'Set wordpress login form background color.', 'pressmart' ),
                'default'  		=> '#ffffff',
            ),
			array(
                'id'       		=> 'wp-login-form-box-shadow',
                'type'     		=> 'switch',
                'title'    		=> esc_html__( 'Login Form Box Shadow','pressmart' ),
                'subtitle'     	=> esc_html__( 'Set login form box shadow.', 'pressmart' ),
                'on'       		=> esc_html__( 'Yes', 'pressmart' ),
				'off'      		=> esc_html__( 'No', 'pressmart' ),
				'default'  		=> 1,
            ),
			array(
				'id'             	=> 'wp-login-form-padding',
				'type'           	=> 'spacing',
				'title'          	=> esc_html__( 'Login Form Padding', 'pressmart' ),
				'subtitle'       	=> esc_html__( 'Add login form spacing using padding.', 'pressmart' ),
				'mode'           	=> 'padding',
				'units'          	=> array( 'em', '%', 'px' ),
				'default'           => array(
					'padding-top' 		=> '2',
					'padding-right' 	=> '2',
					'padding-bottom' 	=> '2',
					'padding-left' 		=> '2',
					'units'         	=> 'em', 
				)
			),
			array(
                'id'       => 'wp-login-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Set text color.', 'pressmart' ),
                'default'  => '#545454',
            ),
			array(
                'id'       => 'wp-login-link-color',
                'type'     => 'link_color',
                'title'    => esc_html__( 'Link Color', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'Set link and hover color.', 'pressmart' ),
				'active'    	=> false,
                'default'  => array(
                    'regular' => '#494949',
                    'hover'   => '#059473',
                )
            ),
			array(
                'id'       => 'wp-login-border',
                'type'     => 'border',
                'title'    => esc_html__( 'Border', 'pressmart' ),                
                'subtitle' 		=> esc_html__( 'Set border color, style and width.', 'pressmart' ),
                'default'  => array(
                    'border-color'  => '#e9e9e9',
                    'border-style'  => 'solid',
                    'border-top'    => '1px',
                    'border-right'  => '1px',
                    'border-bottom' => '1px',
                    'border-left'   => '1px'
                )
            ),
			array(
                'id'            => 'wp-login-border-radius',
                'type'          => 'slider',
                'title'         => esc_html__( 'Border Radius', 'pressmart' ),
				'subtitle' 		=> esc_html__( 'site border radius.', 'pressmart' ),
                'default'       => 4,
                'min'           => 0,
                'step'          => 1,
                'max'           => 50,
                'display_value' => 'label'
            ),
			array(
                'id'       => 'wp-login-input-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Color( TextBox, SelectBox, etc..)', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Set color input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#545454',
            ),
			 array(
                'id'       => 'wp-login-input-background',
                'type'     => 'color',
                'title'    => esc_html__( 'Input Field Background( TextBox, SelectBox, etc..)', 'pressmart' ),
				'subtitle'    	=> esc_html__( 'Set background input field like TextBox, Textarea, SelectBox, etc..', 'pressmart' ),
                'default'  => '#ffffff',
            ),
			array(
                'id'       		=> 'wp-login-button-background',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Background', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button background color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#059473',
                    'hover'   	=> '#199377',
                )
            ),
			array(
                'id'       		=> 'wp-login-button-color',
                'type'     		=> 'link_color',
                'title'    		=> esc_html__( 'Button Color', 'pressmart' ),
                'subtitle' 		=> esc_html__( 'Set button text color and hover color.', 'pressmart' ),
                'active'    	=> false,
                'default'  		=> array(
                    'regular' 	=> '#ffffff',
                    'hover'   	=> '#fcfcfc',
                )
            ),
		)
	) );
	
	/*
	* Custom CSS/JS Code
	*/
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Custom JS/CSS', 'pressmart' ),
        'id'         => 'custom-code',
		'icon'		 => 'el-icon-broom',
        'fields'     => array(
			array(
                'id'       => 'custom-css',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'CSS Code', 'pressmart' ),
                'subtitle' => esc_html__( 'Paste your CSS code here.', 'pressmart' ),
                'mode'     => 'css',
                'theme'    => 'monokai',
                'default'  => ""
            ),	
			array(
				'id'       => 'custom-js-header',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'JS Code before &lt;/head&gt;', 'pressmart' ),
				'subtitle' => esc_html__( 'Paste your JS code here.', 'pressmart' ),
				'mode'     => 'javascript',
				'theme'    => 'chrome',
				'default'  => '',
			),
            array(
                'id'       => 'custom_js',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'JS Code before &lt;/body&gt;', 'pressmart' ),
                'subtitle' => esc_html__( 'Paste your JS code here.', 'pressmart' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome',
                'default'  => "jQuery(document).ready(function(){\n\n});"
            ),
		)
	) );
	
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

      /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'pressmart' ),
                'subtitle'   => esc_html__( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'pressmart' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }