<?php
/**
 * Template part for displaying customer support
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package pressmart/template-parts/header
 * @since 1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}?>			

<?php if( ! empty( pressmart_get_option( 'header-phone-number', '(+123) 4567 890' ) )  || ! empty( pressmart_get_option( 'header-email','support@pressmart.com' ) ) ){ ?>
	<div class="customer-support">
		<div class="customer-support-wrap">
			<?php if( ! empty( pressmart_get_option( 'header-phone-number', '(+123) 4567 890' ) ) ){ ?>
				<span class="contact-phone"><strong><?php esc_html_e('Support: ', 'pressmart');?></strong><?php echo esc_html( pressmart_get_option( 'header-phone-number', '(+123) 4567 890' ) );?></span>
			<?php } ?>
			<?php if( ! empty( pressmart_get_option( 'header-email','support@pressmart.com' ) ) ){ ?>
				<span class="contact-email"><strong><?php esc_html_e('Email: ', 'pressmart');?></strong><?php echo esc_html( pressmart_get_option( 'header-email','support@pressmart.com' ) );?></span>
			<?php } ?>
		</div>
	</div>
<?php } ?>
