<?php
/**
 * Template part for displaying posts layout
 *
 * @author 	PressLayouts
 * @package pressmart/template-parts/post-loop
 * @since 1.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$blog_post_style	= pressmart_get_loop_prop( 'blog-post-style' );	
if( pressmart_get_loop_prop( 'name' ) == 'related-posts' ) {
	$classes[] 	= 'related-post';
}else{
	$classes[]  = 'blog-post-loop';
}
$classes[] = ( ! pressmart_get_loop_prop( 'blog-post-thumbnail' ) ) ? 'no-post-thumbnail' : '';
if( pressmart_get_loop_prop( 'name' ) == 'posts-loop-shortcode' ){
	if( $blog_post_style == 'blog-grid' ){
		$classes[] = 'col-lg-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns' ) );
		$classes[] = 'col-md-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns-tablet' ) );
		$classes[] = 'col-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns-mobile' ) );
	}				
}elseif( $blog_post_style == 'blog-grid' && ! is_single() ){
	if( pressmart_get_loop_prop( 'name' ) != 'posts-slider-shortcode' ){
		$classes[] = 'col-lg-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns' ) );
		$classes[] = 'col-md-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns-tablet' ) );
		$classes[] = 'col-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns-mobile' ) );
	}					
}
$classes[] = ( pressmart_get_loop_prop( 'post-meta' ) ) ? pressmart_get_loop_prop( 'post-meta-separator' ) : '';
$classes[] = ( pressmart_get_loop_prop( 'post-meta' ) && pressmart_get_loop_prop( 'post-meta-icon' ) ) ? 'post-meta-icon' : 'post-meta-label';
?>

<?php do_action( 'pressmart_before_loop_post_entry' ); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ); ?>>
	
	<?php
	/**
	 * pressmart_loop_post_entry_top hook.
	 *
	 * @hooked pressmart_post_wrapper - 10
	 */
	do_action( 'pressmart_loop_post_entry_top' );
	?>
	
	<div class="entry-thumbnail-wrapper">
		<?php 
		/**
		 * pressmart_loop_post_thumbnail hook.
		 *
		 * @hooked pressmart_template_loop_post_highlight - 10
		 * @hooked pressmart_template_loop_post_thumbnail - 20
		 */
		do_action( 'pressmart_loop_post_thumbnail' );
		?>
	</div>
	
	<div class="entry-content-wrapper">
		<?php	
		/**
		 * pressmart_loop_post_content hook.
		 *
		 * @hooked pressmart_loop_post_header 	- 10
		 * @hooked pressmart_loop_post_content 	- 20
		 * @hooked pressmart_loop_post_footer 	- 30
		 */
		do_action( 'pressmart_loop_post_content' );
		?>
	</div>
	
	<?php	
	/**
	 * pressmart_loop_post_entry_bottom hook.
	 *
	 * @hooked pressmart_post_wrapper_end - 10
	 */
	do_action( 'pressmart_loop_post_entry_bottom' );
	?>
		
</article>

<?php
do_action( 'pressmart_after_loop_post_entry' ); 