<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package pressmart/template-parts/single-post
 * @since 1.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$classes[] = 'single-post-page';
$classes[] = ( pressmart_get_option( 'post-meta', 1 ) ) ? pressmart_get_option( 'post-meta-separator', 'meta-separator-colon' ) : '';
$classes[] = ( pressmart_get_option( 'post-meta', 1 ) && pressmart_get_option( 'post-meta-icon', 1) ) ? 'post-meta-icon' : 'post-meta-label';
$classes[] = ( pressmart_get_option( 'single-post-thumbnail', 1 ) && pressmart_has_post_thumbnail() ) ? 'has-post-thumbnail' : 'no-post-thumbnail';
$classes[] = ( is_sticky() ) ? 'sticky' : '';
?>

<?php do_action( 'pressmart_before_single_post_entry' ); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ); ?>>
	
	<?php
	/**
	 * pressmart_single_post_entry_top hook.
	 *
	 * @hooked pressmart_post_wrapper - 10	 
	 */
	do_action( 'pressmart_single_post_entry_top' );
	?>
	
	<div class="entry-thumbnail-wrapper">
		<?php 
		/**
		 * pressmart_single_post_thumbnail hook.
		 *
		 * @hooked pressmart_template_single_post_thumbnail - 10
		 * @hooked pressmart_template_single_post_highlight - 20
		 */
		do_action( 'pressmart_single_post_thumbnail' );
		?>
	</div>
	
	<div class="entry-content-wrapper">
		<?php	
		/**
		 * pressmart_single_post_content hook.
		 *
		 * @hooked pressmart_single_post_header - 10
		 * @hooked pressmart_single_post_content - 20
		 */
		do_action( 'pressmart_single_post_content' );
		?>
	</div>
	
	<?php	
	/**
	 * pressmart_single_post_entry_bottom hook.
	 *
	 * @hooked pressmart_post_wrapper_end - 10
	 */
	do_action( 'pressmart_single_post_entry_bottom' );
	?>
		
</article>

<?php
/**
 * pressmart_after_single_post_entry hook.
 * 
 * @hooked pressmart_template_single_post_author_bios - 10
 * @hooked pressmart_template_single_social_share - 20
 * @hooked pressmart_template_single_post_navigation - 30
 * @hooked pressmart_template_single_related - 40
 * @hooked pressmart_template_single_post_comments - 50
 */
do_action( 'pressmart_after_single_post_entry' ); 